/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client.internal.ext;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJSONProvider;
import org.apache.cxf.rs.security.oauth2.utils.crypto.CryptoUtils;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Util;

public class OAuth2Serializer {
    private static final String AES_CRYPTO_ALGO = "AES";

    public SecretKey decodeSecretKey(String encodedSecretKey, String secretKeyAlgorithm) {
        String secretKeyAlgorithmToUse = secretKeyAlgorithm;
        if (!Strings.isValid((String)secretKeyAlgorithmToUse)) {
            secretKeyAlgorithmToUse = AES_CRYPTO_ALGO;
        }
        return CryptoUtils.decodeSecretKey((String)encodedSecretKey, (String)secretKeyAlgorithmToUse);
    }

    public String encryptAccessToken(ClientAccessToken token, SecretKey secretKey) {
        String json = this.toJson(token);
        return CryptoUtils.encryptSequence((String)json, (Key)secretKey);
    }

    public ClientAccessToken decryptAccessToken(String value, SecretKey secretKey) {
        String decrypted = CryptoUtils.decryptSequence((String)value, (Key)secretKey);
        return this.fromJson(decrypted);
    }

    public ClientAccessToken fromJson(String value) {
        OAuthJSONProvider provider = OAuth2Util.getOAuthJSONProvider();
        InputStream stream = null;
        try {
            stream = Lib.stringToInputStream((String)value);
            Map map = provider.readJSONResponse(stream);
            ClientAccessToken clientAccessToken = OAuthClientUtils.fromMapToClientToken((Map)map);
            return clientAccessToken;
        }
        catch (Exception ex) {
            throw OAuth2Util.newException(ex, "Error deserializing value to client access token", new Object[0]);
        }
        finally {
            Lib.close((AutoCloseable)stream);
        }
    }

    public String toJson(ClientAccessToken token) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OAuthJSONProvider provider = OAuth2Util.getOAuthJSONProvider();
        try {
            provider.writeTo((Object)token, null, null, null, null, null, (OutputStream)os);
        }
        catch (Exception ex) {
            throw OAuth2Util.newException(ex, "Error serializing client access token", new Object[0]);
        }
        return new String(os.toByteArray(), Strings.UTF_8);
    }
}

