/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.define.api.WordArtifactChange;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;

public class WordUpdateChange {
    private TransactionId tx;
    private List<WordArtifactChange> changedArts = new LinkedList<WordArtifactChange>();
    private final Map<Long, String> trackedChangeArts = new HashMap<Long, String>();
    private final Map<Long, String> invalidApplicabilityTagsArts = new HashMap<Long, String>();
    private BranchId branch;

    public TransactionId getTx() {
        return this.tx;
    }

    public void setTx(TransactionId tx) {
        this.tx = tx;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public void setBranch(BranchId branch) {
        this.branch = branch;
    }

    public List<WordArtifactChange> getChangedArts() {
        return this.changedArts;
    }

    public void setChangedArts(List<WordArtifactChange> changedArts) {
        this.changedArts = changedArts;
    }

    public void addChangedArt(WordArtifactChange change) {
        this.changedArts.add(change);
    }

    public WordArtifactChange getWordArtifactChange(long artId) {
        WordArtifactChange toReturn = null;
        if (this.changedArts != null && !this.changedArts.isEmpty()) {
            for (WordArtifactChange change : this.changedArts) {
                if (change.artId != artId) continue;
                toReturn = change;
                break;
            }
        }
        return toReturn;
    }

    public boolean hasSafetyRelatedArtifactChange() {
        boolean hasRelatedChange = false;
        for (WordArtifactChange change : this.changedArts) {
            if (change.isSafetyRelated()) {
                hasRelatedChange = true;
                break;
            }
            if (!change.isCreated()) continue;
            hasRelatedChange = true;
            break;
        }
        return hasRelatedChange;
    }

    public Map<Long, String> getTrackedChangeArts() {
        return this.trackedChangeArts;
    }

    public void setTrackedChangeArts(Long artId, String name) {
        this.trackedChangeArts.put(artId, name);
    }

    public Map<Long, String> getInvalidApplicabilityTagArts() {
        return this.invalidApplicabilityTagsArts;
    }

    public void setInvalidApplicabilityTagArts(Long artId, String name) {
        this.invalidApplicabilityTagsArts.put(artId, name);
    }
}

