/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.define.api.importing;

import java.util.LinkedList;
import org.eclipse.define.api.importing.BlockField;
import org.eclipse.define.api.importing.BlockFieldToken;
import org.eclipse.define.api.importing.DoorsImportFieldTokens;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public abstract class ImportBlock
implements Named {
    protected ArtifactTypeToken type = ArtifactTypeToken.SENTINEL;
    private Boolean complete = false;
    protected final LinkedList<BlockField> attrs = new LinkedList();
    protected final XResultData results;

    protected ImportBlock(XResultData results) {
        this.results = results;
    }

    public Boolean isParentBlock() {
        if (this.type.isValid() && this.type.equals(CoreArtifactTypes.HeadingMsWord)) {
            return true;
        }
        return false;
    }

    public Boolean isComplete() {
        return this.complete;
    }

    public void addAttr(BlockField attr) {
        this.attrs.add(attr);
        if (attr.getImportTypeName().equals("Type")) {
            this.setType(attr);
        }
        if (attr.getImportTypeName().equals(this.getCompleteMarker().getName())) {
            this.complete = true;
        }
    }

    public ArtifactTypeToken getType() {
        return this.type;
    }

    public abstract BlockFieldToken getCompleteMarker();

    public abstract void addContent(String var1);

    public abstract void setType(BlockField var1);

    public BlockField getImportAttrFromName(String attrName) {
        Conditions.assertNotNull((Object)attrName, (String)"null attribute given", (Object[])new Object[0]);
        for (BlockField attr : this.attrs) {
            String localAttrName = attr.getImportTypeName();
            if (!attrName.equals(localAttrName)) continue;
            return attr;
        }
        throw new OseeCoreException("Invalid Attribute Name requested: %s", new Object[]{attrName});
    }

    public BlockField getImportAttr(BlockFieldToken token) {
        for (BlockField attr : this.attrs) {
            if (!attr.getId().equals(token.getId())) continue;
            return attr;
        }
        throw new OseeCoreException("Invalid Attribute requested: %s", new Object[]{token.getName()});
    }

    public RoughArtifact addAttributesToRoughArtifact(RoughArtifact roughArt) {
        if (!this.isComplete().booleanValue()) {
            throw new OseeCoreException("Imported Block not complete", new Object[0]);
        }
        for (BlockField attr : this.attrs) {
            AttributeTypeToken attrType = attr.getOseeType();
            if (!attrType.isValid()) continue;
            roughArt.addAttribute(attrType, attr.getData());
        }
        return roughArt;
    }

    public void addRelationsToRoughArtifact(RoughArtifact roughArt) {
        if (!this.isComplete().booleanValue()) {
            throw new OseeCoreException("Imported Block not complete", new Object[0]);
        }
    }

    public void addText(String text) {
        BlockField textAttr = null;
        for (BlockField attr : this.attrs) {
            if (!attr.getId().equals(DoorsImportFieldTokens.blockAttrText.getId())) continue;
            textAttr = attr;
            break;
        }
        if (textAttr == null) {
            textAttr = DoorsImportFieldTokens.blockAttrText.getNewParser();
            textAttr.appendContent(text, true);
            this.attrs.add(textAttr);
        } else {
            textAttr.appendContent(text, false);
        }
    }

    public void addAdditionalAttribute(BlockFieldToken token, String text) {
        BlockField addAttr = token.getNewParser();
        addAttr.setData(text);
        this.attrs.add(addAttr);
    }

    public void replaceReference(String objectID, String reference) {
        BlockField textAttr = null;
        for (BlockField attr : this.attrs) {
            if (!attr.getId().equals(DoorsImportFieldTokens.blockAttrText.getId())) continue;
            textAttr = attr;
            break;
        }
        if (textAttr == null) {
            System.out.println("textAttribute was null");
        } else {
            String newContent = textAttr.getData().replaceAll("\\[" + objectID + "\\]", reference);
            textAttr.setData(newContent);
        }
    }

    public void addAttribute(BlockFieldToken token, String text) {
        BlockField addAttr = null;
        for (BlockField attr : this.attrs) {
            if (!attr.getId().equals(token.getId())) continue;
            addAttr = attr;
            break;
        }
        if (addAttr == null) {
            addAttr = token.getNewParser();
            addAttr.setData(text);
            this.attrs.add(addAttr);
        } else {
            addAttr.setData(text);
        }
    }
}

