/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osee.framework.jdk.core.text.RulesLogHandler;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public abstract class Rule {
    private final String outExtension;
    private String currentOutfileName;
    private File inputFile;
    private String subdirectoryName;
    private Pattern fileNamePattern;
    protected boolean ruleWasApplicable;
    protected Logger logger;
    private int modCount;
    private String charsetString = "UTF8";

    public Rule() {
        this("done");
    }

    public Rule(String outExtension) {
        this.outExtension = outExtension;
        this.ruleWasApplicable = false;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.setLevel(Level.ALL);
        this.subdirectoryName = null;
    }

    public abstract ChangeSet computeChanges(CharSequence var1);

    public final int process(Collection<File> list) {
        for (File file : list) {
            try {
                this.process(file);
            }
            catch (Exception ex) {
                System.out.println(String.valueOf(this.currentOutfileName) + ": " + ex.getMessage());
            }
        }
        return this.modCount;
    }

    public final int process(File file) throws IOException {
        if (file.isDirectory()) {
            List<File> files = Lib.recursivelyListFiles(file, this.fileNamePattern);
            for (File aFile : files) {
                try {
                    this.process(aFile);
                }
                catch (Exception ex) {
                    System.out.println(String.valueOf(this.currentOutfileName) + ": " + ex.getMessage());
                }
            }
        } else {
            this.inputFile = file;
            this.process(file, this.getResultFile(file));
        }
        return this.modCount;
    }

    public final void process(File inFile, File outFile) throws IOException {
        if (this.subdirectoryName != null) {
            File parent = outFile.getParentFile();
            File subdirectory = new File(parent, this.subdirectoryName);
            if (!subdirectory.mkdir()) {
                throw new IOException("Could not create directory");
            }
            outFile = new File(subdirectory, outFile.getName());
        }
        this.currentOutfileName = outFile.getName();
        if (inFile.exists()) {
            ChangeSet changeSet;
            block13: {
                RulesLogHandler handler = null;
                changeSet = null;
                try {
                    try {
                        handler = new RulesLogHandler(new File(Lib.changeExtension(outFile.getPath(), "xml")));
                        this.logger.addHandler(handler);
                        this.ruleWasApplicable = false;
                        changeSet = this.computeChanges(Lib.fileToCharBuffer(inFile, this.charsetString));
                    }
                    catch (ParserConfigurationException ex) {
                        this.logger.log(Level.SEVERE, ex.toString(), ex);
                        if (handler != null) {
                            handler.close();
                            this.logger.removeHandler(handler);
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (handler != null) {
                        handler.close();
                        this.logger.removeHandler(handler);
                    }
                    throw throwable;
                }
                if (handler != null) {
                    handler.close();
                    this.logger.removeHandler(handler);
                }
            }
            if (this.ruleWasApplicable) {
                String path = this.subdirectoryName == null ? "" : this.subdirectoryName;
                System.out.println("Rule was applied to " + path + this.currentOutfileName);
                ++this.modCount;
                if (changeSet != null) {
                    changeSet.applyChanges(outFile);
                }
            }
        }
    }

    protected final File getResultFile(File file) {
        if (this.outExtension == null) {
            return file;
        }
        return new File(String.valueOf(Lib.removeExtension(file.getPath())) + "." + this.outExtension);
    }

    public static void main(String[] args) throws Exception {
        block11: {
            if (args.length < 3) {
                System.out.println("Usage: " + Rule.class.getName() + " <ruleClassPath> <ruleClass> <file list>");
                return;
            }
            String ruleName = args[1];
            String classPath = args[0];
            try {
                URLClassLoader classLoader = new URLClassLoader(new URL[]{Lib.getUrlFromString(classPath)});
                System.out.println("class path: " + classLoader.getURLs()[0]);
                Object obj = classLoader.loadClass(ruleName).newInstance();
                if (obj instanceof Rule) {
                    Rule rule = (Rule)obj;
                    int i = 2;
                    while (i < args.length) {
                        try {
                            File file = new File(args[i]);
                            if (!file.exists()) {
                                System.out.println("The file " + file + " does not exist!");
                            } else {
                                rule.process(file);
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("Exception in Rule!!! " + rule.currentOutfileName + ": " + ex.getMessage());
                            ex.printStackTrace();
                        }
                        ++i;
                    }
                    break block11;
                }
                throw new IllegalArgumentException(String.valueOf(ruleName) + " is not of type text.Rule.");
            }
            catch (InstantiationException ex) {
                System.out.println(ex);
            }
            catch (IllegalAccessException ex) {
                System.out.println(ex);
            }
            catch (ClassNotFoundException ex) {
                System.out.println(ex);
            }
        }
    }

    public final boolean ruleWasApplicable() {
        return this.ruleWasApplicable;
    }

    public final String getCurrentOutfileName() {
        return this.currentOutfileName;
    }

    public final void setRuleWasApplicable(boolean ruleWasApplicable) {
        this.ruleWasApplicable = ruleWasApplicable;
    }

    public final File getInputFile() {
        return this.inputFile;
    }

    public final void setSubdirectoryNameToPlaceResultFilesIn(String subdirectoryName) {
        this.subdirectoryName = subdirectoryName;
    }

    public final void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = Pattern.compile(fileNamePattern);
    }

    public final String getCharsetString() {
        return this.charsetString;
    }

    public final void setCharsetString(String charsetString) {
        this.charsetString = charsetString;
    }
}

