/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import java.util.concurrent.Callable;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.OrcsTypesDataStore;
import org.eclipse.osee.orcs.core.internal.types.BranchHierarchyProvider;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesIndex;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesLoader;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesLoaderFactory;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesResourceProvider;
import org.eclipse.osee.orcs.core.internal.types.impl.CreateOrcsTypesIndexCallable;
import org.eclipse.osee.orcs.core.internal.types.impl.OrcsTypesIndexer;

public class OrcsTypesLoaderFactoryImpl
implements OrcsTypesLoaderFactory {
    private final Log logger;
    private final BranchHierarchyProvider hierarchyProvider;

    public OrcsTypesLoaderFactoryImpl(Log logger, BranchHierarchyProvider hierarchyProvider) {
        this.logger = logger;
        this.hierarchyProvider = hierarchyProvider;
    }

    @Override
    public OrcsTypesLoader createTypesLoader(final OrcsSession session, final OrcsTypesDataStore ds) {
        return this.createTypesLoader(session, new OrcsTypesResourceProvider(){

            @Override
            public IResource getOrcsTypesResource() throws Exception {
                return ds.getOrcsTypesLoader(session);
            }
        });
    }

    @Override
    public OrcsTypesLoader createTypesLoader(OrcsSession session, final OrcsTypesResourceProvider provider) {
        return new OrcsTypesLoader(){

            @Override
            public Callable<OrcsTypesIndex> createLoader() {
                OrcsTypesIndexer indexer = new OrcsTypesIndexer(OrcsTypesLoaderFactoryImpl.this.logger, OrcsTypesLoaderFactoryImpl.this.hierarchyProvider);
                return new CreateOrcsTypesIndexCallable(OrcsTypesLoaderFactoryImpl.this.logger, indexer, provider);
            }
        };
    }
}

