/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.internal.types.impl.ArtifactTypeIndex;
import org.eclipse.osee.orcs.data.ArtifactTypes;

public class ArtifactTypesImpl
implements ArtifactTypes {
    private final ArtifactTypeIndexProvider provider;

    public ArtifactTypesImpl(ArtifactTypeIndexProvider provider) {
        this.provider = provider;
    }

    private ArtifactTypeIndex getArtifactTypesIndex() {
        return this.provider.getArtifactTypeIndex();
    }

    private XArtifactType getType(ArtifactTypeId artType) {
        Conditions.checkNotNull((Object)artType, (String)"artifactType");
        return (XArtifactType)this.getArtifactTypesIndex().getDslTypeByToken((Id)artType);
    }

    public Collection<ArtifactTypeToken> getAll() {
        return this.getArtifactTypesIndex().getAllTokens();
    }

    public ArtifactTypeToken get(Id id) {
        return (ArtifactTypeToken)this.getArtifactTypesIndex().get(id);
    }

    public ArtifactTypeToken get(Long id) {
        return (ArtifactTypeToken)this.getArtifactTypesIndex().get(id);
    }

    public boolean isAbstract(ArtifactTypeId artType) {
        XArtifactType type = this.getType(artType);
        return type.isAbstract();
    }

    public boolean hasSuperArtifactTypes(ArtifactTypeId artType) {
        return !this.getSuperArtifactTypes(artType).isEmpty();
    }

    public Collection<? extends ArtifactTypeId> getSuperArtifactTypes(ArtifactTypeId artType) {
        Conditions.checkNotNull((Object)artType, (String)"artifactType");
        return this.getArtifactTypesIndex().getSuperTypes(artType);
    }

    public boolean inheritsFrom(ArtifactTypeId thisType, ArtifactTypeId ... otherTypes) {
        Conditions.checkNotNull((Object)thisType, (String)"thisArtifactType");
        Conditions.checkNotNull((Object)otherTypes, (String)"otherArtifactTypes");
        return this.getArtifactTypesIndex().inheritsFrom(thisType, otherTypes);
    }

    public Collection<? extends ArtifactTypeToken> getAllDescendantTypes(ArtifactTypeId artType) {
        Conditions.checkNotNull((Object)artType, (String)"artifactType");
        LinkedHashSet descendants = Sets.newLinkedHashSet();
        this.walkDescendants(artType, descendants);
        return descendants;
    }

    private void walkDescendants(ArtifactTypeId artifactType, Collection<ArtifactTypeToken> descendants) {
        Collection<ArtifactTypeToken> childTypes = this.getArtifactTypesIndex().getDescendantTypes(artifactType);
        if (!childTypes.isEmpty()) {
            for (ArtifactTypeToken type : childTypes) {
                this.walkDescendants((ArtifactTypeId)type, descendants);
                descendants.add(type);
            }
        }
    }

    public boolean isValidAttributeType(ArtifactTypeId artType, BranchId branch, AttributeTypeId attributeType) {
        Collection<AttributeTypeToken> attributes = this.getAttributeTypes(artType, branch);
        return attributes.contains(attributeType);
    }

    public Collection<AttributeTypeToken> getAttributeTypes(ArtifactTypeId artType, BranchId branch) {
        Conditions.checkNotNull((Object)artType, (String)"artifactType");
        Conditions.checkNotNull((Object)branch, (String)"branch");
        return this.getArtifactTypesIndex().getAttributeTypes(artType, branch);
    }

    public boolean isEmpty() {
        return this.getArtifactTypesIndex().isEmpty();
    }

    public int size() {
        return this.getArtifactTypesIndex().size();
    }

    public boolean exists(Id id) {
        return this.getArtifactTypesIndex().exists(id);
    }

    public Map<BranchId, Collection<AttributeTypeToken>> getAllAttributeTypes(ArtifactTypeId artType) {
        return this.getArtifactTypesIndex().getAllAttributeTypes(artType);
    }

    public static interface ArtifactTypeIndexProvider {
        public ArtifactTypeIndex getArtifactTypeIndex();
    }
}

