/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.BranchQueryBuilderImpl;
import org.eclipse.osee.orcs.search.BranchQuery;

public class BranchQueryImpl
extends BranchQueryBuilderImpl<BranchQuery>
implements BranchQuery {
    private final QueryEngine queryEngine;

    public BranchQueryImpl(QueryEngine queryEngine, BranchCriteriaFactory criteriaFactory, QueryData queryData) {
        super(criteriaFactory, queryData);
        this.queryEngine = queryEngine;
    }

    public ResultSet<Branch> getResults() {
        ArrayList branches = new ArrayList();
        this.query(branches);
        return ResultSets.newResultSet(branches);
    }

    public ResultSet<IOseeBranch> getResultsAsId() {
        ArrayList branches = new ArrayList();
        this.query(branches);
        return ResultSets.newResultSet(branches);
    }

    private void query(List<? super Branch> branches) {
        QueryData queryData = this.build();
        OptionsUtil.setLoadLevel(queryData.getOptions(), LoadLevel.ALL);
        this.queryEngine.runBranchQuery(queryData, branches);
    }

    public int getCount() {
        return this.queryEngine.getBranchCount(this.build());
    }

    public boolean exists() {
        return this.getCount() > 0;
    }
}

