/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.script.impl;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.DataModule;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptAssembler;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptCompiler;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptException;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptExecutor;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptInterpreter;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptOutputHandler;
import org.eclipse.osee.orcs.core.internal.script.impl.ExcelOutputHandler;
import org.eclipse.osee.orcs.core.internal.script.impl.JsonOutputHandler;
import org.eclipse.osee.orcs.core.internal.script.impl.OrcsScriptAssemblerImpl;
import org.eclipse.osee.orcs.core.internal.script.impl.OrcsScriptInterpreterImpl;
import org.eclipse.osee.orcs.core.internal.search.QueryModule;
import org.eclipse.osee.orcs.script.dsl.IExpressionResolver;
import org.eclipse.osee.orcs.script.dsl.IFieldResolver;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptDslResource;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptUtil;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OrcsScript;

public class OrcsScriptCompilerImpl
implements OrcsScriptCompiler {
    private final OrcsSession session;
    private final DataModule dataModule;
    private final OrcsTypes orcsTypes;
    private final QueryModule queryModule;
    private OrcsScriptInterpreter interpreter;

    public OrcsScriptCompilerImpl(OrcsSession session, DataModule dataModule, OrcsTypes orcsTypes, QueryModule queryModule) {
        this.session = session;
        this.dataModule = dataModule;
        this.orcsTypes = orcsTypes;
        this.queryModule = queryModule;
    }

    private OrcsScriptInterpreter getInterpreter() {
        if (this.interpreter == null) {
            IExpressionResolver resolver = OrcsScriptUtil.getExpressionResolver();
            IFieldResolver fieldResolver = OrcsScriptUtil.getFieldResolver();
            this.interpreter = new OrcsScriptInterpreterImpl(this.orcsTypes, resolver, fieldResolver);
        }
        return this.interpreter;
    }

    private OrcsScriptOutputHandler getOutputHandler(ScriptContext context) {
        OrcsScriptOutputHandler handler = null;
        String output = (String)context.getAttribute("output.mime-type");
        handler = Strings.isValid((String)output) && "excel-xml".equalsIgnoreCase(output) ? new ExcelOutputHandler(context) : new JsonOutputHandler(context);
        return handler;
    }

    private OrcsScriptAssembler getAssembler(OrcsScriptOutputHandler output) {
        return new OrcsScriptAssemblerImpl(this.dataModule, this.orcsTypes, output, this.queryModule);
    }

    private OrcsScriptExecutor getExecutor(OrcsScriptAssembler assembler) {
        return (OrcsScriptExecutor)((Object)assembler);
    }

    @Override
    public OrcsScriptCompiler.OrcsCompiledScript compileReader(Reader reader, String filename) throws OrcsScriptException {
        OrcsScript model = this.parse(reader, filename);
        return new OrcsCompiledScriptImpl(model);
    }

    private OrcsScript parse(Reader reader, String filename) throws OrcsScriptException {
        OrcsScriptDslResource resource = null;
        ByteArrayInputStream inputStream = null;
        try {
            try {
                String uri = "orcs:/dummy.orcs";
                inputStream = new ByteArrayInputStream(this.read(reader).getBytes(Strings.UTF_8));
                resource = OrcsScriptUtil.loadModelSafely((InputStream)inputStream, (String)uri);
            }
            catch (IOException ex) {
                throw OrcsScriptException.newException(ex);
            }
        }
        catch (Throwable throwable) {
            Lib.close(inputStream);
            throw throwable;
        }
        Lib.close((AutoCloseable)inputStream);
        if (resource.hasErrors()) {
            throw OrcsScriptException.newException(filename, resource.getErrors());
        }
        return resource.getModel();
    }

    private String read(Reader reader) throws IOException {
        String script = CharStreams.toString((Readable)reader);
        if (Strings.isValid((String)script) && !(script = script.trim()).endsWith(";")) {
            script = String.valueOf(script) + ';';
        }
        return script;
    }

    private final class OrcsCompiledScriptImpl
    implements OrcsScriptCompiler.OrcsCompiledScript {
        private final OrcsScript model;

        public OrcsCompiledScriptImpl(OrcsScript model) {
            this.model = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object eval(ScriptContext context) throws OrcsScriptException {
            OrcsScriptOutputHandler output = OrcsScriptCompilerImpl.this.getOutputHandler(context);
            try {
                output.onEvalStart();
                Map<String, Object> parameters = this.asMap(context);
                OrcsScriptAssembler assembler = OrcsScriptCompilerImpl.this.getAssembler(output);
                OrcsScript orcsScript = this.model;
                synchronized (orcsScript) {
                    try {
                        OrcsScriptUtil.bind((EObject)this.model, parameters);
                        OrcsScriptInterpreter interpreter = OrcsScriptCompilerImpl.this.getInterpreter();
                        interpreter.interpret(this.model, assembler);
                    }
                    finally {
                        OrcsScriptUtil.unbind((EObject)this.model);
                    }
                }
                OrcsScriptExecutor executor = OrcsScriptCompilerImpl.this.getExecutor(assembler);
                Object object = executor.execute(OrcsScriptCompilerImpl.this.session, parameters);
                return object;
            }
            catch (Exception ex) {
                throw OrcsScriptException.newException(ex);
            }
            finally {
                output.onEvalEnd();
            }
        }

        private Map<String, Object> asMap(ScriptContext context) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            for (Integer scope : context.getScopes()) {
                Bindings bindings = context.getBindings(scope);
                if (bindings == null) continue;
                for (Map.Entry entry : bindings.entrySet()) {
                    data.put((String)entry.getKey(), entry.getValue());
                }
            }
            return data;
        }
    }
}

