/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.graph.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.internal.graph.GraphAdjacencies;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.graph.GraphNode;

public class GraphDataImpl
implements GraphData {
    private final Map<ArtifactId, GraphNode> nodesById = new ConcurrentHashMap<ArtifactId, GraphNode>();
    private final Map<ArtifactId, GraphAdjacencies> adjacenciesById = new ConcurrentHashMap<ArtifactId, GraphAdjacencies>();
    private final BranchId branch;
    private final TransactionId txId;
    private final OrcsSession orcsSession;

    public GraphDataImpl(OrcsSession session, BranchId branch, TransactionId txId) {
        this.orcsSession = session;
        this.branch = branch;
        this.txId = txId;
    }

    public TransactionId getTransaction() {
        return this.txId;
    }

    @Override
    public <T extends GraphNode> T getNode(ArtifactId artifactId) {
        return (T)this.nodesById.get(artifactId);
    }

    @Override
    public void addNode(GraphNode node, boolean useBackingData) {
        boolean sameBranches = this.getBranch().equals(node.getBranch());
        if (!sameBranches) {
            throw new OseeArgumentException("Invalid node added to graph. Graph[%s] Node[%s]", new Object[]{this, node.getExceptionString()});
        }
        GraphData oldGraph = node.getGraph();
        if (!this.equals(oldGraph) || useBackingData) {
            if (oldGraph != null) {
                oldGraph.removeNode((ArtifactId)node);
            }
            this.nodesById.put((ArtifactId)node, node);
            node.setGraph(this);
        }
    }

    @Override
    public <T extends GraphNode> T removeNode(ArtifactId node) {
        GraphNode removed = this.nodesById.remove(node);
        this.removeAdjacencies(node);
        return (T)removed;
    }

    @Override
    public <T extends GraphAdjacencies> T getAdjacencies(ArtifactId node) {
        return (T)this.adjacenciesById.get(node);
    }

    @Override
    public void addAdjacencies(ArtifactId node, GraphAdjacencies adjacencies) {
        this.adjacenciesById.put(node, adjacencies);
    }

    @Override
    public <T extends GraphAdjacencies> T removeAdjacencies(ArtifactId node) {
        return (T)this.adjacenciesById.remove(node);
    }

    public String toString() {
        return String.format("Graph - branch[%s] txId[%s] nodes[%s] adjacencies[%s]", this.getBranch(), this.getTransaction(), this.nodesById.size(), this.adjacenciesById.size());
    }

    public int hashCode() {
        int result = this.getBranch().hashCode();
        result = 31 * result + this.getTransaction().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GraphData)) {
            return false;
        }
        GraphData other = (GraphData)obj;
        if (!this.isOnSameBranch(other)) {
            return false;
        }
        return !this.getTransaction().notEqual((Id)other.getTransaction());
    }

    @Override
    public OrcsSession getSession() {
        return this.orcsSession;
    }

    public BranchId getBranch() {
        return this.branch;
    }
}

