/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.internal.branch.AbstractBranchCallable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class CommitBranchCallable
extends AbstractBranchCallable<TransactionToken> {
    private final ArtifactId committer;
    private final BranchId source;
    private final BranchId destination;
    private final QueryFactory queryFactory;
    private final OrcsTypes orcsTypes;

    public CommitBranchCallable(Log logger, OrcsSession session, BranchDataStore branchStore, QueryFactory queryFactory, ArtifactId committer, BranchId source, BranchId destination, OrcsTypes orcsTypes) {
        super(logger, session, branchStore);
        this.committer = committer;
        this.source = source;
        this.destination = destination;
        this.queryFactory = queryFactory;
        this.orcsTypes = orcsTypes;
    }

    @Override
    protected TransactionToken innerCall() throws Exception {
        Conditions.checkNotNull((Object)this.source, (String)"sourceBranch");
        Conditions.checkNotNull((Object)this.destination, (String)"destinationBranch");
        Branch sourceBranch = (Branch)((BranchQuery)this.queryFactory.branchQuery().andId(this.source)).getResults().getExactlyOne();
        TransactionToken sourceHead = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andIsHead(this.source)).getResults().getExactlyOne();
        Branch destinationBranch = (Branch)((BranchQuery)this.queryFactory.branchQuery().andId(this.destination)).getResults().getExactlyOne();
        TransactionToken destinationHead = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andIsHead(this.destination)).getResults().getExactlyOne();
        Conditions.checkNotNull((Object)sourceBranch, (String)"sourceBranch");
        Conditions.checkNotNull((Object)destinationBranch, (String)"destinationBranch");
        TransactionId newTx = this.getBranchStore().commitBranch(this.getSession(), this.committer, this.orcsTypes, sourceBranch, sourceHead, destinationBranch, destinationHead, this.queryFactory);
        return (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andTxId(newTx)).getResults().getExactlyOne();
    }
}

