/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.config.admin.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osee.config.admin.internal.ConfigManagerConfiguration;
import org.eclipse.osee.config.admin.internal.ConfigManagerConfigurationBuilder;
import org.eclipse.osee.config.admin.internal.ConfigParser;
import org.eclipse.osee.config.admin.internal.ConfigUtil;
import org.eclipse.osee.config.admin.internal.ConfigWriter;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.UriWatcher;
import org.eclipse.osee.logger.Log;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigManagerImpl
implements UriWatcher.UriWatcherListener {
    private final ConfigParser parser = new ConfigParser();
    private Log logger;
    private ConfigurationAdmin configAdmin;
    private ConfigManagerConfiguration config;
    private final AtomicReference<UriWatcher> watcherRef = new AtomicReference();
    private final Map<String, ServiceConfig> services = new HashMap<String, ServiceConfig>();

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void start(Map<String, Object> properties) {
        this.logger.trace("Starting ConfigurationManagerImpl...", new Object[0]);
        this.update(properties);
    }

    public void stop() {
        this.logger.trace("Stopping ConfigurationManagerImpl...", new Object[0]);
        UriWatcher watcher = this.watcherRef.get();
        this.close(watcher);
    }

    public void update(Map<String, Object> properties) {
        this.logger.trace("Configuring ConfigurationManagerImpl...", new Object[0]);
        ConfigManagerConfiguration newConfig = ConfigManagerConfigurationBuilder.newBuilder().properties(properties).build();
        if (Compare.isDifferent((Object)this.config, (Object)newConfig)) {
            this.configure(newConfig);
            this.config = newConfig;
        }
    }

    private void configure(ConfigManagerConfiguration config) {
        this.logger.info("Configuration Manager settings: [%s]", new Object[]{config});
        this.logger.warn("configuration file [" + config.getConfigUri() + "]", new Object[0]);
        URI configUri = ConfigUtil.asUri(config.getConfigUri());
        if (configUri != null) {
            long pollTime = config.getPollTime();
            TimeUnit timeUnit = config.getTimeUnit();
            this.logger.warn("Reading configuration from: [%s] every [%s %s]", new Object[]{configUri, pollTime, timeUnit});
            UriWatcher newWatcher = new UriWatcher(pollTime, timeUnit);
            newWatcher.addUri(configUri);
            newWatcher.addListener((UriWatcher.UriWatcherListener)this);
            UriWatcher oldWatcher = this.watcherRef.getAndSet(newWatcher);
            this.close(oldWatcher);
            newWatcher.start();
            this.processUri(configUri);
        } else {
            this.logger.warn("Invalid configuration file", new Object[0]);
        }
    }

    private void close(UriWatcher watcher) {
        if (watcher != null) {
            watcher.stop();
            watcher.removeListener((UriWatcher.UriWatcherListener)this);
        }
    }

    private void processUri(URI uri) {
        try {
            String source = Lib.inputStreamToString((InputStream)uri.toURL().openStream());
            final HashMap<String, Dictionary<String, Object>> newConfigs = new HashMap<String, Dictionary<String, Object>>();
            this.parser.process(new ConfigWriter(){

                @Override
                public void write(String serviceId, Dictionary<String, Object> props) {
                    newConfigs.put(serviceId, props);
                }
            }, source);
            this.configureServices(newConfigs);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error processing config [%s]", new Object[]{uri});
        }
    }

    public void handleException(Exception ex) {
        this.logger.error((Throwable)ex, "Error monitoring framework configuration [%s]", new Object[]{this.config});
    }

    public void modificationDateChanged(Collection<URI> uris) {
        for (URI uri : uris) {
            this.processUri(uri);
        }
    }

    private void configureServices(Map<String, Dictionary<String, Object>> newConfigs) {
        List removed = Collections.setComplement(this.services.keySet(), newConfigs.keySet());
        for (String string : removed) {
            ServiceConfig component = this.services.remove(string);
            if (component == null) continue;
            component.stop();
        }
        for (Map.Entry entry : newConfigs.entrySet()) {
            String serviceId = (String)entry.getKey();
            ServiceConfig component = this.services.get(serviceId);
            if (component == null) {
                component = new ServiceConfig(serviceId);
                this.services.put(serviceId, component);
            }
            component.update((Dictionary)entry.getValue());
        }
    }

    private final class ServiceConfig {
        private final AtomicBoolean isRegistered = new AtomicBoolean(false);
        private final String serviceId;
        private Dictionary<String, Object> properties;

        public ServiceConfig(String serviceId) {
            this.serviceId = serviceId;
        }

        public void update(Dictionary<String, Object> config) {
            if (!this.isRegistered.getAndSet(true) || Compare.isDifferent(config, this.properties)) {
                this.properties = config;
                try {
                    Configuration configuration = ConfigManagerImpl.this.configAdmin.getConfiguration(this.serviceId, null);
                    configuration.update(config);
                    if (ConfigManagerImpl.this.logger.isDebugEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        ConfigUtil.writeConfig(configuration, builder);
                        ConfigManagerImpl.this.logger.debug(builder.toString(), new Object[0]);
                    }
                }
                catch (IOException ex) {
                    ConfigManagerImpl.this.logger.error((Throwable)ex, "Error configuring [%s] - config [%s]", new Object[]{this.serviceId, config});
                }
            }
        }

        public void stop() {
            if (this.isRegistered.getAndSet(false)) {
                try {
                    Configuration configuration = ConfigManagerImpl.this.configAdmin.getConfiguration(this.serviceId, null);
                    configuration.delete();
                }
                catch (IOException ex) {
                    ConfigManagerImpl.this.logger.error((Throwable)ex, "Error removing config [%s]", new Object[]{this.serviceId});
                }
            }
        }
    }
}

