/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer.callable.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.JoinItem;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.IndexedResource;
import org.eclipse.osee.orcs.core.ds.OrcsDataHandler;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexedResourceLoader;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagCollector;
import org.eclipse.osee.orcs.db.internal.search.tagger.Tagger;
import org.eclipse.osee.orcs.db.internal.search.tagger.TaggingEngine;
import org.eclipse.osee.orcs.search.IndexerCollector;

public final class IndexingTaskDatabaseTxCallable
extends AbstractDatastoreTxCallable<Long> {
    private static final String INSERT_SEARCH_TAG = "insert into osee_search_tags (gamma_id, coded_tag_id) values (?, ?)";
    private static final String DELETE_SEARCH_TAGS = "delete from osee_search_tags where gamma_id = ?";
    private final IndexedResourceLoader loader;
    private final TaggingEngine taggingEngine;
    private final IndexerCollector collector;
    private final int tagQueueQueryId;
    private final boolean isCacheAll;
    private final int cacheLimit;
    private final AttributeTypes attributeTypes;
    private final long waitStartTime = System.currentTimeMillis();
    private long startTime;
    private long waitTime;

    public IndexingTaskDatabaseTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, IndexedResourceLoader loader, TaggingEngine taggingEngine, IndexerCollector collector, int tagQueueQueryId, boolean isCacheAll, int cacheLimit, AttributeTypes attributeTypes) {
        super(logger, session, jdbcClient);
        this.loader = loader;
        this.taggingEngine = taggingEngine;
        this.collector = collector;
        this.tagQueueQueryId = tagQueueQueryId;
        this.cacheLimit = cacheLimit;
        this.isCacheAll = isCacheAll;
        this.attributeTypes = attributeTypes;
    }

    public int getTagQueueQueryId() {
        return this.tagQueueQueryId;
    }

    private OrcsDataHandler<IndexedResource> createCollector(final Collection<IndexedResource> sources) {
        return new OrcsDataHandler<IndexedResource>(){

            public void onData(IndexedResource data) {
                sources.add(data);
            }
        };
    }

    @Override
    protected Long handleTxWork(JdbcConnection connection) {
        long totalTags;
        block5: {
            this.getLogger().debug("Tagging: [%s]", new Object[]{this.getTagQueueQueryId()});
            totalTags = -1L;
            try {
                LinkedHashSet<IndexedResource> sources = new LinkedHashSet<IndexedResource>();
                OrcsDataHandler<IndexedResource> handler = this.createCollector(sources);
                this.loader.loadSource(handler, this.getTagQueueQueryId(), this.attributeTypes);
                if (!sources.isEmpty()) {
                    try {
                        this.deleteTags(connection, sources);
                        totalTags = this.createTags(connection, sources);
                        this.removeIndexingTaskFromQueue(connection);
                        break block5;
                    }
                    catch (Exception ex) {
                        throw new OseeCoreException((Throwable)ex, "Unable to store tags - tagQueueQueryId [%d]", new Object[]{this.getTagQueueQueryId()});
                    }
                }
                this.getLogger().warn("Empty gamma query id: %s", new Object[]{this.getTagQueueQueryId()});
            }
            catch (Throwable throwable) {
                this.getLogger().debug("End Tagging: [%s] totalTags[%s]", new Object[]{this.getTagQueueQueryId(), totalTags});
                throw throwable;
            }
        }
        this.getLogger().debug("End Tagging: [%s] totalTags[%s]", new Object[]{this.getTagQueueQueryId(), totalTags});
        return totalTags;
    }

    private long createTags(JdbcConnection connection, Collection<IndexedResource> sources) {
        SearchTagCollector tagCollector = new SearchTagCollector();
        HashSet<Long> processed = new HashSet<Long>();
        HashMap<Long, Collection<Long>> toStore = new HashMap<Long, Collection<Long>>();
        for (IndexedResource source : sources) {
            long endItemTime;
            long startItemTime = System.currentTimeMillis();
            GammaId gamma = source.getGammaId();
            if (!processed.add(gamma.getId())) continue;
            HashSet<Long> tags = new HashSet<Long>();
            toStore.put(gamma.getId(), tags);
            tagCollector.setCurrentTag(gamma.getId(), tags);
            try {
                try {
                    TaggerTypeToken taggerType = this.attributeTypes.getTaggerId(source.getAttributeType());
                    if (taggerType.isValid()) {
                        Tagger tagger = this.taggingEngine.getTagger(taggerType);
                        tagger.tagIt(source.getResourceInput(), tagCollector);
                        if (this.isStorageAllowed(toStore)) {
                            this.getLogger().debug("Stored a - [%s] - connectionId[%s] - [%s]", new Object[]{this.getTagQueueQueryId(), connection, toStore});
                            this.storeTags(connection, toStore);
                        }
                    } else {
                        this.getLogger().error("Field has invalid tagger[%s] provider and cannot be tagged - [Gamma: %s]", new Object[]{taggerType, gamma});
                    }
                }
                catch (Exception ex) {
                    this.getLogger().error((Throwable)ex, "Unable to tag - [%s]", new Object[]{gamma});
                    endItemTime = System.currentTimeMillis() - startItemTime;
                    this.notifyOnIndexItemComplete(gamma, tags.size(), endItemTime);
                    continue;
                }
            }
            catch (Throwable throwable) {
                endItemTime = System.currentTimeMillis() - startItemTime;
                this.notifyOnIndexItemComplete(gamma, tags.size(), endItemTime);
                throw throwable;
            }
            endItemTime = System.currentTimeMillis() - startItemTime;
            this.notifyOnIndexItemComplete(gamma, tags.size(), endItemTime);
        }
        if (!toStore.isEmpty()) {
            this.getLogger().debug("Stored b - [%s] - connectionId[%s] - [%s]", new Object[]{this.getTagQueueQueryId(), connection, toStore});
            this.storeTags(connection, toStore);
        }
        return tagCollector.getTotalTags();
    }

    @Override
    protected void handleTxException(Exception ex) {
        super.handleTxException(ex);
        if (this.collector != null) {
            this.collector.onIndexTaskError(this.getTagQueueQueryId(), (Throwable)ex);
        }
    }

    @Override
    protected void onExecutionStart() {
        super.onExecutionStart();
        this.startTime = System.currentTimeMillis();
        this.waitTime = this.startTime - this.waitStartTime;
    }

    @Override
    protected void onExecutionComplete() {
        super.onExecutionComplete();
        if (this.collector != null) {
            this.collector.onIndexTaskComplete(this.getTagQueueQueryId(), this.waitTime, System.currentTimeMillis() - this.startTime);
        }
    }

    private void removeIndexingTaskFromQueue(JdbcConnection connection) {
        this.getJdbcClient().runPreparedUpdate(connection, JoinItem.TAG_GAMMA_QUEUE.getDeleteSql(), new Object[]{this.getTagQueueQueryId()});
    }

    private boolean isStorageAllowed(Map<Long, Collection<Long>> searchTags) {
        int cummulative = 0;
        boolean needsStorage = false;
        for (Collection<Long> tags : searchTags.values()) {
            if (this.isCacheAll || (cummulative += tags.size()) < this.cacheLimit) continue;
            needsStorage = true;
            break;
        }
        return needsStorage;
    }

    public int deleteTags(JdbcConnection connection, Collection<IndexedResource> sources) {
        int numberDeleted = 0;
        if (!sources.isEmpty()) {
            ArrayList<Object[]> datas = new ArrayList<Object[]>();
            for (IndexedResource source : sources) {
                datas.add(new Object[]{source.getGammaId()});
            }
            numberDeleted = this.getJdbcClient().runBatchUpdate(connection, DELETE_SEARCH_TAGS, datas);
        }
        return numberDeleted;
    }

    private int storeTags(JdbcConnection connection, Map<Long, Collection<Long>> toStore) {
        int updated = 0;
        if (!toStore.isEmpty()) {
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            for (Map.Entry<Long, Collection<Long>> entry : toStore.entrySet()) {
                Long gammaId = entry.getKey();
                for (Long codedTag : entry.getValue()) {
                    data.add(new Object[]{gammaId, codedTag});
                    this.getLogger().debug("Storing: gamma:[%s] tag:[%s]", new Object[]{gammaId, codedTag});
                }
            }
            toStore.clear();
            if (!data.isEmpty()) {
                updated += this.getJdbcClient().runBatchUpdate(connection, INSERT_SEARCH_TAG, data);
            }
        }
        return updated;
    }

    private void notifyOnIndexItemComplete(GammaId gammaId, int totalTags, long processingTime) {
        if (this.collector != null) {
            this.collector.onIndexItemComplete(this.getTagQueueQueryId(), gammaId.getId().longValue(), totalTags, processingTime);
        }
    }

    private void notifyOnIndexItemAdded(long gammaId, String word, long codedTag) {
        if (this.collector != null) {
            this.collector.onIndexItemAdded(this.getTagQueueQueryId(), gammaId, word, codedTag);
        }
    }

    private final class SearchTagCollector
    implements TagCollector {
        private Long gammaId;
        private Set<Long> currentTag;
        private long totalTags = 0L;

        public void setCurrentTag(Long gammaId, Set<Long> currentTag) {
            this.gammaId = gammaId;
            this.currentTag = currentTag;
        }

        public long getTotalTags() {
            return this.totalTags;
        }

        @Override
        public void addTag(String word, Long codedTag) {
            if (this.currentTag != null && this.gammaId != null && this.currentTag.add(codedTag)) {
                ++this.totalTags;
                IndexingTaskDatabaseTxCallable.this.notifyOnIndexItemAdded(this.gammaId, word, codedTag);
            }
        }
    }
}

