/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.ObjectType;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.TableEnum;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeRaw;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class AttributeRawSqlHandler
extends SqlHandler<CriteriaAttributeRaw> {
    private CriteriaAttributeRaw criteria;
    private String attrAlias;
    private String txsAlias;
    private String valueJoinAlias;
    private AbstractJoinQuery valueJoinQuery;
    private String typeJoinAlias;
    private AbstractJoinQuery typeJoinQuery;
    private Collection<String> values;
    private boolean ignoreCase;
    private Collection<AttributeTypeId> types;

    @Override
    public void setData(CriteriaAttributeRaw criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.values = this.getValuesForSearch();
        if (this.values.size() > 1) {
            this.valueJoinQuery = writer.writeCharJoin(this.values);
            this.valueJoinAlias = writer.addTable(TableEnum.CHAR_JOIN_TABLE);
        }
        this.types = this.criteria.getAttributeTypes();
        if (this.types.size() > 1) {
            this.typeJoinQuery = writer.writeJoin(this.types);
            this.typeJoinAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.attrAlias = writer.addTable(TableEnum.ATTRIBUTE_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ATTRIBUTE);
    }

    private Collection<String> getValuesForSearch() {
        List copy = Lists.newArrayList((Iterable)this.criteria.getValues());
        this.ignoreCase = this.criteria.getOptions().contains(QueryOption.CASE__IGNORE);
        if (this.ignoreCase) {
            copy = Lists.transform((List)copy, (Function)new Function<String, String>(){

                public String apply(String arg0) {
                    return arg0.toLowerCase();
                }
            });
        }
        return copy;
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        List<String> aliases;
        Collection attributeTypes = this.criteria.getAttributeTypes();
        if (attributeTypes.size() == 1) {
            writer.write(this.attrAlias);
            writer.write(".attr_type_id = ?");
            writer.addParameter(attributeTypes.iterator().next());
        } else if (attributeTypes.size() > 1) {
            writer.write(this.attrAlias);
            writer.write(".attr_type_id = ");
            writer.write(this.typeJoinAlias);
            writer.write(".id");
            writer.write(" AND ");
            writer.write(this.typeJoinAlias);
            writer.write(".query_id = ?");
            writer.addParameter(this.typeJoinQuery.getQueryId());
        }
        if (this.values.size() == 1) {
            String value = this.values.iterator().next();
            writer.write(" AND ");
            if (this.ignoreCase) {
                writer.write("lower(");
            }
            writer.write(this.attrAlias);
            writer.write(".value");
            String ending = this.ignoreCase ? ") " : " ";
            writer.write(ending);
            if (value.contains("%")) {
                writer.write(" LIKE ");
            } else {
                writer.write("=");
            }
            writer.write(" ?");
            writer.addParameter(value);
        }
        if (this.valueJoinQuery != null) {
            writer.write(" AND ");
            if (this.ignoreCase) {
                writer.write("lower(");
            }
            writer.write(this.attrAlias);
            writer.write(".value");
            String ending = this.ignoreCase ? ") = " : " = ";
            writer.write(ending);
            writer.write(this.valueJoinAlias);
            writer.write(".id AND ");
            writer.write(this.valueJoinAlias);
            writer.write(".query_id = ?");
            writer.addParameter(this.valueJoinQuery.getQueryId());
        }
        if (!(aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE)).isEmpty()) {
            writer.writeAndLn();
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write(artAlias);
                writer.write(".art_id = ");
                writer.write(this.attrAlias);
                writer.write(".art_id");
                if (index + 1 < aSize) {
                    writer.write(" AND ");
                }
                ++index;
            }
        }
        writer.write(" AND ");
        writer.write(this.attrAlias);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias);
        writer.write(".gamma_id AND ");
        writer.writeTxBranchFilter(this.txsAlias);
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_VALUE.ordinal();
    }
}

