/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.CountingLoadDataHandler;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryContext;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeKeywords;
import org.eclipse.osee.orcs.db.internal.search.QueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.QueryFilterFactory;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.AbstractSearchCallable;
import org.eclipse.osee.orcs.db.internal.search.engines.QueryFilterFactoryImpl;

public class ObjectQueryCallableFactory
implements QueryCallableFactory {
    private final Log logger;
    private final DataLoaderFactory dataLoaderFactory;
    private final QuerySqlContextFactory queryContextFactory;
    private final QueryFilterFactory factory;

    public ObjectQueryCallableFactory(Log logger, DataLoaderFactory dataLoaderFactory, QuerySqlContextFactory queryEngine, QueryFilterFactoryImpl factory) {
        this.logger = logger;
        this.dataLoaderFactory = dataLoaderFactory;
        this.queryContextFactory = queryEngine;
        this.factory = factory;
    }

    @Override
    public QuerySqlContextFactory getSqlContextFactory() {
        return this.queryContextFactory;
    }

    private boolean isLoadLevelTooLow(LoadLevel level) {
        return LoadLevel.ARTIFACT_DATA == level;
    }

    @Override
    public int getArtifactCount(QueryData queryData) {
        QuerySqlContext queryContext = this.queryContextFactory.createQueryContext(null, queryData, QueryType.SELECT);
        DataLoader loader = this.dataLoaderFactory.newDataLoader((QueryContext)queryContext);
        loader.setOptions(queryData.getOptions());
        if (this.isLoadLevelTooLow(OptionsUtil.getLoadLevel((Options)queryData.getOptions()))) {
            OptionsUtil.setLoadLevel((Options)queryData.getOptions(), (LoadLevel)LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA);
        }
        CountingLoadDataHandler countingHandler = this.factory.createHandler(queryData, queryContext, null);
        loader.load(null, (LoadDataHandler)countingHandler);
        return countingHandler.getCount();
    }

    @Override
    public CancellableCallable<Integer> createQuery(OrcsSession session, QueryData queryData, final LoadDataHandler handler) {
        return new AbstractObjectSearchCallable(this, this.logger, session, queryData){

            @Override
            protected Integer innerCall() throws Exception {
                boolean enableFilter = this.isPostProcessRequired();
                return this.loadAndGetCount(handler, enableFilter);
            }
        };
    }

    private abstract class AbstractObjectSearchCallable
    extends AbstractSearchCallable {
        public AbstractObjectSearchCallable(Log logger, OrcsSession session, QueryData queryData) {
            super(logger, session, queryData);
        }

        private boolean isLoadLevelTooLow(LoadLevel level) {
            return LoadLevel.ARTIFACT_DATA == level;
        }

        protected boolean isPostProcessRequired() {
            return this.getQueryData().hasCriteriaType(CriteriaAttributeKeywords.class);
        }

        protected int loadAndGetCount(LoadDataHandler handler, boolean enableFilter) throws Exception {
            LoadLevel level;
            QuerySqlContext queryContext = ObjectQueryCallableFactory.this.queryContextFactory.createQueryContext(this.getSession(), this.getQueryData(), QueryType.SELECT);
            this.checkForCancelled();
            DataLoader loader = ObjectQueryCallableFactory.this.dataLoaderFactory.newDataLoader((QueryContext)queryContext);
            loader.setOptions(this.getQueryData().getOptions());
            if (enableFilter && this.isLoadLevelTooLow(level = loader.getLoadLevel())) {
                loader.withLoadLevel(LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA);
            }
            CountingLoadDataHandler countingHandler = ObjectQueryCallableFactory.this.factory.createHandler(this.getQueryData(), queryContext, handler);
            loader.load((HasCancellation)this, (LoadDataHandler)countingHandler);
            return countingHandler.getCount();
        }
    }
}

