/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceProvider;
import org.eclipse.osee.framework.resource.management.exception.MalformedLocatorException;
import org.eclipse.osee.framework.resource.management.util.OptionsProcessor;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.db.internal.resource.ResourceConstants;

public class ExchangeProvider
implements IResourceProvider {
    private String binaryDataPath;
    private String exchangeDataPath;
    private SystemPreferences preferences;
    private boolean isInitialized = false;

    public void setSystemPreferences(SystemPreferences preferences) {
        this.preferences = preferences;
    }

    public void start() {
        this.binaryDataPath = ResourceConstants.getBinaryDataPath(this.preferences);
        this.exchangeDataPath = ResourceConstants.getExchangeDataPath(this.preferences);
        this.isInitialized = true;
    }

    public void stop() {
        this.binaryDataPath = null;
        this.exchangeDataPath = null;
        this.isInitialized = false;
    }

    private synchronized void ensureInitialized() {
        Conditions.checkExpressionFailOnTrue((!this.isInitialized ? 1 : 0) != 0, (String)"Exchange Data Path - not initialized - ensure start() was called", (Object[])new Object[0]);
        Conditions.checkNotNull((Object)this.binaryDataPath, (String)"binary data path");
        Conditions.checkNotNull((Object)this.exchangeDataPath, (String)"exchange data path");
    }

    public String getExchangeDataPath() {
        this.ensureInitialized();
        return this.exchangeDataPath;
    }

    public String getBinaryDataPath() {
        this.ensureInitialized();
        return this.binaryDataPath;
    }

    private URI resolve(IResourceLocator locator) {
        URI toReturn = null;
        StringBuilder builder = new StringBuilder();
        String rawPath = locator.getRawPath();
        if (!rawPath.startsWith("file:/")) {
            builder.append(this.getExchangeDataPath());
            builder.append(rawPath);
            File file = new File(builder.toString());
            toReturn = file.toURI();
        } else {
            rawPath = rawPath.replaceAll(" ", "%20");
            try {
                toReturn = new URI(rawPath);
            }
            catch (URISyntaxException ex) {
                throw new MalformedLocatorException((Throwable)ex);
            }
        }
        return toReturn;
    }

    public IResource acquire(IResourceLocator locator, PropertyStore options) {
        IResource toReturn = null;
        OptionsProcessor optionsProcessor = new OptionsProcessor(this.resolve(locator), locator, null, options);
        toReturn = optionsProcessor.getResourceToServer();
        return toReturn;
    }

    public int delete(IResourceLocator locator) {
        boolean result;
        int toReturn = 2;
        File file = new File(this.resolve(locator));
        if (!file.exists()) {
            toReturn = 3;
        } else if (file.exists() && file.canWrite() && (result = Lib.deleteFileAndEmptyParents((String)this.getBinaryDataPath(), (File)file))) {
            toReturn = 1;
        }
        return toReturn;
    }

    public boolean isValid(IResourceLocator locator) {
        return locator != null && this.getSupportedProtocols().contains(locator.getProtocol());
    }

    public IResourceLocator save(IResourceLocator locator, IResource resource, PropertyStore options) {
        IResourceLocator toReturn;
        block7: {
            toReturn = null;
            OptionsProcessor optionsProcessor = new OptionsProcessor(this.resolve(locator), locator, resource, options);
            FileOutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                try {
                    File storageFile = optionsProcessor.getStorageFile();
                    File parent = storageFile.getParentFile();
                    if (parent != null) {
                        Lib.emptyDirectory((File)parent);
                    }
                    IResource resourceToStore = optionsProcessor.getResourceToStore();
                    outputStream = new FileOutputStream(storageFile);
                    inputStream = resourceToStore.getContent();
                    Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
                    toReturn = optionsProcessor.getActualResouceLocator();
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    Lib.close(outputStream);
                    Lib.close(inputStream);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Lib.close(outputStream);
                Lib.close(inputStream);
                throw throwable;
            }
            Lib.close((AutoCloseable)outputStream);
            Lib.close((AutoCloseable)inputStream);
        }
        if (toReturn == null) {
            throw new OseeStateException("We failed to save resource %s.", new Object[]{locator.getLocation()});
        }
        return toReturn;
    }

    public boolean exists(IResourceLocator locator) {
        URI uri = this.resolve(locator);
        File testFile = new File(uri);
        return testFile.exists();
    }

    public Collection<String> getSupportedProtocols() {
        return Arrays.asList("exchange");
    }
}

