/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.processor;

import java.util.Date;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.loader.data.AttributeObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.processor.LoadProcessor;

public class AttributeLoadProcessor
extends LoadProcessor<AttributeData, AttributeObjectFactory> {
    private final Log logger;
    private final AttributeTypes attributeTypes;

    public AttributeLoadProcessor(Log logger, AttributeObjectFactory factory, AttributeTypes attributeTypes) {
        super(factory);
        this.logger = logger;
        this.attributeTypes = attributeTypes;
    }

    @Override
    protected AttributeData createData(Object conditions, AttributeObjectFactory factory, JdbcStatement chStmt, Options options) {
        AttributeData<Boolean> toReturn = null;
        BranchId branch = BranchId.create((Long)chStmt.getLong("branch_id"), (ArtifactId)OptionsUtil.getFromBranchView((Options)options));
        ArtifactId artId = ArtifactId.valueOf((Long)chStmt.getLong("id2"));
        int attrId = chStmt.getInt("attr_id");
        GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
        ModificationType modType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
        ApplicabilityId applicId = ApplicabilityId.valueOf((Long)chStmt.getLong("app_id"));
        boolean historical = OptionsUtil.isHistorical((Options)options);
        CreateConditions condition = this.asConditions(conditions);
        if (!condition.isSame(branch, artId, attrId)) {
            condition.saveConditions(branch, artId, attrId, gammaId, modType);
            TransactionId txId = TransactionId.valueOf((Long)chStmt.getLong("transaction_id"));
            VersionData version = factory.createVersion(branch, txId, gammaId, historical);
            if (historical) {
                version.setStripeId(TransactionId.valueOf((Long)chStmt.getLong("stripe_transaction_id")));
            }
            AttributeTypeToken attributeType = (AttributeTypeToken)this.attributeTypes.get(Long.valueOf(chStmt.getLong("attr_type_id")));
            String baseAttributeType = this.attributeTypes.getBaseAttributeTypeId((AttributeTypeId)attributeType);
            Object value = null;
            if (baseAttributeType.contains("BooleanAttribute")) {
                value = chStmt.getBoolean("value");
            } else if (baseAttributeType.contains("FloatingPointAttribute")) {
                value = chStmt.getDouble("value");
            } else if (baseAttributeType.contains("IntegerAttribute")) {
                value = chStmt.getInt("value");
            } else if (baseAttributeType.contains("LongAttribute")) {
                value = chStmt.getLong("value");
            } else if (baseAttributeType.contains("ArtifactReferenceAttribute")) {
                String id = chStmt.getString("value");
                if (Strings.isNumeric((String)id)) {
                    value = ArtifactId.valueOf((String)id);
                } else {
                    this.logger.error("Inavlid non-numeric value [%s] for ArtRefAttribute [%s] attrId [%s] on artId [%s]", new Object[]{id, attributeType.getIdString(), attrId, artId});
                }
            } else if (baseAttributeType.contains("BranchReferenceAttribute")) {
                value = BranchId.valueOf((String)chStmt.getString("value"));
            } else if (baseAttributeType.contains("DateAttribute")) {
                value = new Date(chStmt.getLong("value"));
            } else {
                value = chStmt.getString("value");
                if (baseAttributeType.contains("EnumeratedAttribute")) {
                    value = Strings.intern((String)((String)value));
                }
            }
            String uri = chStmt.getString("uri");
            toReturn = factory.createAttributeData(version, attrId, attributeType, modType, artId, value, uri, applicId);
        } else if (!historical) {
            this.logger.warn("multiple attribute versions for attribute id [%s] artifact id[%s] branch[%s] previousGammaId[%s] currentGammaId[%s] previousModType[%s] currentModType[%s]", new Object[]{attrId, artId, branch, condition.previousGammaId, gammaId, condition.previousModType, modType});
        }
        return toReturn;
    }

    @Override
    protected Object createPreConditions(Options options) {
        return new CreateConditions();
    }

    private CreateConditions asConditions(Object conditions) {
        return (CreateConditions)conditions;
    }

    private static final class CreateConditions {
        ArtifactId previousArtId = ArtifactId.SENTINEL;
        BranchId previousBranchId = BranchId.SENTINEL;
        int previousAttrId = -1;
        GammaId previousGammaId = GammaId.SENTINEL;
        ModificationType previousModType = null;

        private CreateConditions() {
        }

        boolean isSame(BranchId branch, ArtifactId artifactId, int attrId) {
            return this.previousBranchId.equals(branch) && this.previousArtId.equals(artifactId) && this.previousAttrId == attrId;
        }

        void saveConditions(BranchId branch, ArtifactId artifactId, int attrId, GammaId gammaId, ModificationType modType) {
            this.previousBranchId = branch;
            this.previousArtId = artifactId;
            this.previousAttrId = attrId;
            this.previousGammaId = gammaId;
            this.previousModType = modType;
        }
    }
}

