/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.executors;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.db.internal.loader.LoadSqlContext;
import org.eclipse.osee.orcs.db.internal.loader.LoadUtil;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaOrcsLoad;
import org.eclipse.osee.orcs.db.internal.loader.executors.AbstractLoadExecutor;
import org.eclipse.osee.orcs.db.internal.search.engines.ArtifactQuerySqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ArtifactQueryContextLoadExecutor
extends AbstractLoadExecutor {
    private final ArtifactQuerySqlContext queryContext;
    private final SqlJoinFactory joinFactory;

    public ArtifactQueryContextLoadExecutor(SqlObjectLoader loader, JdbcClient jdbcClient, SqlJoinFactory joinFactory, ArtifactQuerySqlContext queryContext) {
        super(loader, jdbcClient);
        this.queryContext = queryContext;
        this.joinFactory = joinFactory;
    }

    @Override
    public void load(HasCancellation cancellation, LoadDataHandler handler, CriteriaOrcsLoad criteria, Options options) {
        int fetchSize = this.computeFetchSize(this.queryContext);
        Id4JoinQuery join = this.createId4Join(this.getJdbcClient(), cancellation, fetchSize);
        OptionsUtil.setFromBranchView((Options)options, (ArtifactId)this.queryContext.getBranch().getViewId());
        LoadSqlContext loadContext = new LoadSqlContext(this.queryContext.getSession(), options, this.queryContext.getBranch());
        this.getLoader().loadArtifacts(cancellation, handler, join, criteria, loadContext, fetchSize);
    }

    private int computeFetchSize(SqlContext sqlContext) {
        int fetchSize = 10;
        for (AbstractJoinQuery join : sqlContext.getJoins()) {
            fetchSize = Math.max(fetchSize, join.size());
        }
        return LoadUtil.computeFetchSize(fetchSize);
    }

    /*
     * Unable to fully structure code
     */
    private Id4JoinQuery createId4Join(JdbcClient jdbcClient, HasCancellation cancellation, int fetchSize) {
        artifactJoin = this.joinFactory.createId4JoinQuery();
        try {
            for (AbstractJoinQuery join : this.queryContext.getJoins()) {
                join.store();
                this.checkCancelled(cancellation);
            }
            transactionId = OptionsUtil.getFromTransaction((Options)this.queryContext.getOptions());
            viewId = OptionsUtil.getFromBranchView((Options)this.queryContext.getOptions());
            consumer = (Consumer<JdbcStatement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.eclipse.osee.framework.core.executor.HasCancellation org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery org.eclipse.osee.framework.core.data.TransactionId org.eclipse.osee.framework.core.data.ArtifactId org.eclipse.osee.jdbc.JdbcStatement ), (Lorg/eclipse/osee/jdbc/JdbcStatement;)V)((ArtifactQueryContextLoadExecutor)this, (HasCancellation)cancellation, (Id4JoinQuery)artifactJoin, (TransactionId)transactionId, (ArtifactId)viewId);
            this.checkCancelled(cancellation);
            query = this.queryContext.getSql();
            params = this.queryContext.getParameters();
            this.getJdbcClient().runQuery(consumer, fetchSize, query, params.toArray());
        }
        finally {
            ** for (join : this.queryContext.getJoins())
        }
lbl-1000:
        // 1 sources

        {
            try {
                join.close();
            }
            catch (OseeCoreException v0) {}
            continue;
        }
lbl23:
        // 1 sources

        return artifactJoin;
    }

    private /* synthetic */ void lambda$0(HasCancellation hasCancellation, Id4JoinQuery id4JoinQuery, TransactionId transactionId, ArtifactId artifactId, JdbcStatement stmt) {
        this.checkCancelled(hasCancellation);
        ArtifactId artiafct = ArtifactId.valueOf((Long)stmt.getLong("art_id"));
        BranchId branch = BranchId.valueOf((Long)stmt.getLong("branch_id"));
        id4JoinQuery.add((Id)branch, (Id)artiafct, (Id)transactionId, (Id)artifactId);
        this.checkCancelled(hasCancellation);
    }
}

