/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;

public final class IndexCollector {
    private final ExportItem source;
    private final String primaryKey;
    private final Set<String> aliases;
    private final Set<String> negativeOneAliases;
    private final Set<Long> ids;
    private final Map<String, Set<Long>> notFound;

    IndexCollector(ExportItem source, String primaryKey, String[] aliases, String[] negativeOneAliases) {
        String alias;
        int n;
        int n2;
        String[] stringArray;
        this.source = source;
        this.primaryKey = primaryKey.toLowerCase();
        this.ids = java.util.Collections.synchronizedSet(new HashSet());
        this.aliases = new HashSet<String>();
        if (aliases != null && aliases.length > 0) {
            stringArray = aliases;
            n2 = aliases.length;
            n = 0;
            while (n < n2) {
                alias = stringArray[n];
                this.aliases.add(alias.toLowerCase());
                ++n;
            }
        }
        this.aliases.add(this.primaryKey);
        this.negativeOneAliases = new HashSet<String>();
        if (negativeOneAliases != null && negativeOneAliases.length > 0) {
            stringArray = negativeOneAliases;
            n2 = negativeOneAliases.length;
            n = 0;
            while (n < n2) {
                alias = stringArray[n];
                this.negativeOneAliases.add(alias.toLowerCase());
                ++n;
            }
        }
        this.aliases.addAll(this.negativeOneAliases);
        this.notFound = java.util.Collections.synchronizedMap(new HashMap());
    }

    IndexCollector(ExportItem source, String primaryKey, String[] aliases) {
        this(source, primaryKey, aliases, null);
    }

    IndexCollector(ExportItem source, String primaryKey) {
        this(source, primaryKey, new String[]{primaryKey}, null);
    }

    public ExportItem getSource() {
        return this.source;
    }

    void processData(String source, Map<String, String> fieldMap) {
        String value;
        if (this.source.toString().equals(source) && fieldMap.containsKey(this.primaryKey) && Strings.isValid((String)(value = fieldMap.get(this.primaryKey)))) {
            this.ids.add(Long.valueOf(value));
        }
        ArrayList intersect = Collections.setIntersection(this.aliases, fieldMap.keySet());
        for (String key : intersect) {
            long toCheck;
            String value2 = fieldMap.get(key);
            if (!Strings.isValid((String)value2) || this.ids.contains(toCheck = Long.valueOf(value2).longValue()) || this.negativeOneAliases.contains(key) || toCheck == -1L) continue;
            this.addValue(key, toCheck);
        }
    }

    private void addValue(String key, Long value) {
        Set<Long> values = this.notFound.get(key);
        if (values == null) {
            values = java.util.Collections.synchronizedSet(new HashSet());
            this.notFound.put(key, values);
        }
        values.add(value);
    }

    protected void removeFalsePositives() {
        if (!this.notFound.isEmpty()) {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (String key : this.notFound.keySet()) {
                Collection values = this.notFound.get(key);
                if (values == null) continue;
                if (!values.isEmpty()) {
                    values.removeAll(this.ids);
                    if (!this.negativeOneAliases.contains(key)) continue;
                    values.remove(-1L);
                    continue;
                }
                keysToRemove.add(key);
            }
            for (String key : keysToRemove) {
                this.notFound.remove(key);
            }
        }
    }

    public boolean hasErrors() {
        return !this.notFound.isEmpty();
    }

    public Map<String, Set<Long>> getItemsNotFound() {
        return this.notFound;
    }
}

