/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.change;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.type.DoubleKeyHashMap;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.ExportImportJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class LoadDeltasBetweenBranches {
    private static final String SELECT_ALL_SOURCE_ADDRESSING = "with\ntxsOuter as (select transaction_id, gamma_id, mod_type, app_id from osee_txs txs where \nbranch_id = ? and txs.tx_current <> ? and transaction_id <> ? AND \nNOT EXISTS (SELECT 1 FROM osee_txs txs1 WHERE txs1.branch_id = ? AND txs1.transaction_id = ? \nAND txs1.gamma_id = txs.gamma_id and txs1.mod_type = txs.mod_type and txs1.app_id = txs.app_id)) \nSELECT 1 as table_type, attr_type_id as item_type_id, attr_id as item_id, art_id as item_first, 0 as item_second, 0 as item_third, 0 as item_fourth, value as item_value, item.gamma_id, mod_type, app_id \nFROM osee_attribute item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 2 as table_type, art_type_id as item_type_id, art_id as item_id, 0 as item_first, 0 as item_second, 0 as item_third, 0 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id \nFROM osee_artifact item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 3 as table_type, rel_link_type_id as item_type_id, rel_link_id as item_id,  a_art_id as item_first, b_art_id as item_second, 0 as item_third, 0 as item_fourth, rationale as item_value, item.gamma_id, mod_type, app_id \nFROM osee_relation_link item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 4 as table_type, tuple_type as item_type_id, 0 as item_id, e1 as item_first, e2 as item_second, 0 as item_third, 0 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id \nfrom osee_tuple2 item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 5 as table_type, tuple_type as item_type_id, 0 as item_id, e1 as item_first, e2 as item_second, e3 as item_third, 0 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id \nfrom osee_tuple3 item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 6 as table_type, tuple_type as item_type_id, 0 as item_id, e1 as item_first, e2 as item_second, e3 as item_third, e4 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id \nfrom osee_tuple4 item, txsOuter where txsOuter.gamma_id = item.gamma_id";
    private static final String SELECT_BASE_TX = "select baseline_transaction_id from osee_branch where branch_id = ?";
    private final JdbcClient jdbcClient;
    private final OrcsTypes orcsTypes;
    private final BranchId sourceBranch;
    private final BranchId destinationBranch;
    private final BranchId mergeBranch;
    private final TransactionId mergeTxId;
    private final TransactionToken sourceTx;
    private final TransactionToken destinationTx;
    private final SqlJoinFactory joinFactory;
    private final HashMap<Long, ApplicabilityToken> applicTokens;
    private final ApplicabilityQuery applicabilityQuery;
    private final MissingChangeItemFactory missingChangeItemFactory;

    public LoadDeltasBetweenBranches(JdbcClient jdbcClient, SqlJoinFactory joinFactory, OrcsTypes orcsTypes, BranchId sourceBranch, BranchId destinationBranch, TransactionToken sourceTx, TransactionToken destinationTx, BranchId mergeBranch, QueryFactory queryFactory, MissingChangeItemFactory missingChangeItemFactory) {
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.orcsTypes = orcsTypes;
        this.sourceBranch = sourceBranch;
        this.destinationBranch = destinationBranch;
        this.sourceTx = sourceTx;
        this.destinationTx = destinationTx;
        this.mergeBranch = mergeBranch;
        this.applicabilityQuery = queryFactory.applicabilityQuery();
        this.missingChangeItemFactory = missingChangeItemFactory;
        this.applicTokens = this.applicabilityQuery.getApplicabilityTokens(sourceBranch, destinationBranch);
        this.mergeTxId = mergeBranch.isValid() ? (TransactionId)((TransactionQuery)queryFactory.transactionQuery().andIsHead(mergeBranch)).getResults().getExactlyOne() : TransactionId.SENTINEL;
    }

    private ApplicabilityToken getApplicabilityToken(ApplicabilityId appId) {
        ApplicabilityToken toReturn = this.applicTokens.get(appId.getId());
        if (toReturn != null) {
            return toReturn;
        }
        return ApplicabilityToken.BASE;
    }

    private boolean hasMergeBranch() {
        return this.mergeBranch.isValid();
    }

    public List<ChangeItem> call() {
        Conditions.checkExpressionFailOnTrue((boolean)this.sourceBranch.equals(this.destinationBranch), (String)"Unable to compute deltas between transactions on the same branch [%s]", (Object[])new Object[]{this.sourceBranch});
        TransactionId sourceBaselineTxId = (TransactionId)this.jdbcClient.fetch((Object)TransactionId.SENTINEL, SELECT_BASE_TX, new Object[]{this.sourceBranch});
        DoubleKeyHashMap<Integer, Long, ChangeItem> newChangeData = this.loadSourceBranchChanges(sourceBaselineTxId);
        List<ChangeItem> changes = this.loadItemsbyId(newChangeData, sourceBaselineTxId);
        changes.addAll(this.missingChangeItemFactory.createMissingChanges(changes, this.sourceTx, this.destinationTx, this.applicabilityQuery));
        return changes;
    }

    private List<ChangeItem> loadItemsbyId(DoubleKeyHashMap<Integer, Long, ChangeItem> changeData, TransactionId sourceBaselineTxId) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ExportImportJoinQuery idJoin = this.joinFactory.createExportImportJoinQuery();){
            for (Integer i : changeData.getKeySetOne()) {
                for (ChangeItem item : changeData.allValues((Object)i)) {
                    idJoin.add(i, item.getItemId());
                }
            }
            idJoin.store();
            if (this.hasMergeBranch()) {
                this.loadCurrentVersionData(idJoin, changeData, this.mergeBranch, this.mergeTxId, true);
            }
            this.loadCurrentVersionData(idJoin, changeData, this.destinationBranch, (TransactionId)this.destinationTx, false);
            this.loadNonCurrentSourceVersionData(idJoin, changeData, sourceBaselineTxId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LinkedList<ChangeItem> list = new LinkedList<ChangeItem>(changeData.allValues());
        return list;
    }

    private DoubleKeyHashMap<Integer, Long, ChangeItem> loadSourceBranchChanges(TransactionId sourceBaselineTxId) {
        DoubleKeyHashMap hashChangeData = new DoubleKeyHashMap();
        Consumer<JdbcStatement> consumer = stmt -> {
            GammaId gammaId = GammaId.valueOf((Long)stmt.getLong("gamma_id"));
            ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
            ApplicabilityId appId = ApplicabilityId.valueOf((Long)stmt.getLong("app_id"));
            int tableType = stmt.getInt("table_type");
            Long itemId = stmt.getLong("item_id");
            Long itemTypeId = stmt.getLong("item_type_id");
            switch (tableType) {
                case 1: {
                    ArtifactId artId = ArtifactId.valueOf((Long)stmt.getLong("item_first"));
                    String value = stmt.getString("item_value");
                    hashChangeData.put((Object)1, (Object)itemId, (Object)ChangeItemUtil.newAttributeChange((AttributeId)AttributeId.valueOf((Long)itemId), (AttributeTypeId)((AttributeTypeId)this.orcsTypes.getAttributeTypes().get(itemTypeId)), (ArtifactId)artId, (GammaId)gammaId, (ModificationType)modType, (String)value, (ApplicabilityToken)this.getApplicabilityToken(appId)));
                    break;
                }
                case 2: {
                    hashChangeData.put((Object)2, (Object)itemId, (Object)ChangeItemUtil.newArtifactChange((ArtifactId)ArtifactId.valueOf((Long)itemId), (ArtifactTypeId)((ArtifactTypeId)this.orcsTypes.getArtifactTypes().get(itemTypeId)), (GammaId)gammaId, (ModificationType)modType, (ApplicabilityToken)this.getApplicabilityToken(appId)));
                    break;
                }
                case 3: {
                    ArtifactId aArtId = ArtifactId.valueOf((Long)stmt.getLong("item_first"));
                    ArtifactId bArtId = ArtifactId.valueOf((Long)stmt.getLong("item_second"));
                    String rationale = stmt.getString("item_value");
                    hashChangeData.put((Object)3, (Object)itemId, (Object)ChangeItemUtil.newRelationChange((RelationId)RelationId.valueOf((Long)itemId), (RelationTypeId)((RelationTypeId)this.orcsTypes.getRelationTypes().get(itemTypeId)), (GammaId)gammaId, (ModificationType)modType, (ArtifactId)aArtId, (ArtifactId)bArtId, (String)rationale, (ApplicabilityToken)this.getApplicabilityToken(appId)));
                    break;
                }
                case 4: {
                    long e1 = stmt.getLong("item_first");
                    long e2 = stmt.getLong("item_second");
                    hashChangeData.put((Object)4, (Object)gammaId.getId(), (Object)ChangeItemUtil.newTupleChange((TupleTypeId)TupleTypeId.valueOf((Long)itemTypeId), (GammaId)gammaId, (ApplicabilityToken)this.getApplicabilityToken(appId), (Long[])new Long[]{e1, e2}));
                    break;
                }
                case 5: {
                    long e1 = stmt.getLong("item_first");
                    long e2 = stmt.getLong("item_second");
                    long e3 = stmt.getLong("item_third");
                    hashChangeData.put((Object)5, (Object)gammaId.getId(), (Object)ChangeItemUtil.newTupleChange((TupleTypeId)TupleTypeId.valueOf((Long)itemTypeId), (GammaId)gammaId, (ApplicabilityToken)this.getApplicabilityToken(appId), (Long[])new Long[]{e1, e2, e3}));
                    break;
                }
                case 6: {
                    long e1 = stmt.getLong("item_first");
                    long e2 = stmt.getLong("item_second");
                    long e3 = stmt.getLong("item_third");
                    long e4 = stmt.getLong("item_fourth");
                    hashChangeData.put((Object)6, (Object)gammaId.getId(), (Object)ChangeItemUtil.newTupleChange((TupleTypeId)TupleTypeId.valueOf((Long)itemTypeId), (GammaId)gammaId, (ApplicabilityToken)this.getApplicabilityToken(appId), (Long[])new Long[]{e1, e2, e3, e4}));
                }
            }
        };
        this.jdbcClient.runQuery(consumer, 10000, SELECT_ALL_SOURCE_ADDRESSING, new Object[]{this.sourceBranch, TxCurrent.NOT_CURRENT, sourceBaselineTxId, this.sourceBranch, sourceBaselineTxId});
        return hashChangeData;
    }

    private void loadCurrentVersionData(ExportImportJoinQuery idJoin, DoubleKeyHashMap<Integer, Long, ChangeItem> changesByItemId, BranchId txBranchId, TransactionId txId, boolean isMergeBranch) {
        Consumer<JdbcStatement> consumer = stmt -> {
            Long itemId = stmt.getLong("item_id");
            Integer tableType = stmt.getInt("table_type");
            ApplicabilityId appId = ApplicabilityId.valueOf((Long)stmt.getLong("app_id"));
            GammaId gammaId = GammaId.valueOf((Long)stmt.getLong("gamma_id"));
            ChangeItem change = (ChangeItem)changesByItemId.get((Object)tableType, (Object)itemId);
            if (isMergeBranch) {
                change.getNetChange().setGammaId(gammaId);
                change.getNetChange().setModType(ModificationType.MERGED);
                change.getNetChange().setApplicabilityToken(this.getApplicabilityToken(appId));
            } else {
                change.getDestinationVersion().setModType(ModificationType.valueOf((long)stmt.getInt("mod_type")));
                change.getDestinationVersion().setGammaId(gammaId);
                change.getDestinationVersion().setApplicabilityToken(this.getApplicabilityToken(appId));
            }
        };
        String query = "select txs.gamma_id, txs.mod_type, txs.app_id, item.art_id as item_id, 2 as table_type from osee_join_export_import idj, osee_artifact item, osee_txs txs where idj.query_id = ? and idj.id2 = item.art_id and idj.id1 = 2 and item.gamma_id = txs.gamma_id and txs.tx_current <> ? and txs.branch_id = ? and txs.transaction_id <= ? union all select txs.gamma_id, txs.mod_type, txs.app_id, item.attr_id as item_id, 1 as table_type from osee_join_export_import idj, osee_attribute item, osee_txs txs where idj.query_id = ? and idj.id2 = item.attr_id and idj.id1 = 1 and item.gamma_id = txs.gamma_id and txs.tx_current <> ? and txs.branch_id = ? and txs.transaction_id <= ? union all select txs.gamma_id, txs.mod_type, txs.app_id, item.rel_link_id as item_id, 3 as table_type from osee_join_export_import idj, osee_relation_link item, osee_txs txs where idj.query_id = ? and idj.id2 = item.rel_link_id and idj.id1 = 3 and item.gamma_id = txs.gamma_id and txs.tx_current <> ? and txs.branch_id = ? and txs.transaction_id <= ?";
        this.jdbcClient.runQuery(consumer, 10000, query, new Object[]{idJoin.getQueryId(), TxCurrent.NOT_CURRENT, txBranchId, txId, idJoin.getQueryId(), TxCurrent.NOT_CURRENT, txBranchId, txId, idJoin.getQueryId(), TxCurrent.NOT_CURRENT, txBranchId, txId});
    }

    private void loadNonCurrentSourceVersionData(ExportImportJoinQuery idJoin, DoubleKeyHashMap<Integer, Long, ChangeItem> changesByItemId, TransactionId sourceBaselineTxId) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (JdbcStatement chStmt = this.jdbcClient.getStatement();){
            String query = "select * from (select null as value, item.art_id as item_id, txs.gamma_id, txs.mod_type, txs.app_id, txs.transaction_id, idj.id2, 2 as table_type from osee_join_export_import idj, osee_artifact item, osee_txs txs where idj.query_id = ? and idj.id2 = item.art_id and idj.id1 = 2 and item.gamma_id = txs.gamma_id and txs.tx_current = ? and txs.branch_id = ? union all select item.value as value, item.attr_id as item_id, txs.gamma_id, txs.mod_type, txs.app_id, txs.transaction_id, idj.id2, 1 as table_type from osee_join_export_import idj, osee_attribute item, osee_txs txs where idj.query_id = ? and idj.id2 = item.attr_id and idj.id1 = 1 and item.gamma_id = txs.gamma_id and txs.tx_current = ? and txs.branch_id = ? union all select null as value, item.rel_link_id as item_id, txs.gamma_id, txs.mod_type, txs.app_id, txs.transaction_id, idj.id2, 3 as table_type from osee_join_export_import idj, osee_relation_link item, osee_txs txs where idj.query_id = ? and idj.id2 = item.rel_link_id and idj.id1 = 3 and item.gamma_id = txs.gamma_id and txs.tx_current = ? and txs.branch_id = ?) t order by t.id2, t.transaction_id asc";
            chStmt.runPreparedQuery(10000, query, new Object[]{idJoin.getQueryId(), TxCurrent.NOT_CURRENT, this.sourceBranch, idJoin.getQueryId(), TxCurrent.NOT_CURRENT, this.sourceBranch, idJoin.getQueryId(), TxCurrent.NOT_CURRENT, this.sourceBranch});
            Long previousItemId = -1L;
            boolean isFirstSet = false;
            while (chStmt.next()) {
                Long itemId = chStmt.getLong("item_id");
                Integer tableType = chStmt.getInt("table_type");
                Long transactionId = chStmt.getLong("transaction_id");
                ApplicabilityId appId = ApplicabilityId.valueOf((Long)chStmt.getLong("app_id"));
                ModificationType modType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
                GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
                String value = chStmt.getString("value");
                ChangeItem change = (ChangeItem)changesByItemId.get((Object)tableType, (Object)itemId);
                if (!previousItemId.equals(itemId)) {
                    isFirstSet = false;
                }
                if (sourceBaselineTxId.equals(transactionId)) {
                    this.setVersionData(change.getBaselineVersion(), gammaId, modType, value, appId);
                } else if (!isFirstSet) {
                    this.setVersionData(change.getFirstNonCurrentChange(), gammaId, modType, value, appId);
                    isFirstSet = true;
                }
                previousItemId = itemId;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void setVersionData(ChangeVersion versionedChange, GammaId gammaId, ModificationType modType, String value, ApplicabilityId appId) {
        if (versionedChange.getGammaId() == null || versionedChange.getGammaId().getId().compareTo(gammaId.getId()) < 0) {
            versionedChange.setValue(value);
            versionedChange.setModType(modType);
            versionedChange.setGammaId(gammaId);
            versionedChange.setApplicabilityToken(this.getApplicabilityToken(appId));
        }
    }
}

