/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints;

import java.util.UUID;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.ResourceOwnerNameProvider;
import org.apache.cxf.rs.security.oauth2.provider.SessionAuthenticityTokenProvider;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.ClientProvider;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.ClientRegistrationData;
import org.eclipse.osee.logger.Log;

public abstract class AbstractClientService {
    private MessageContext mc;
    private final Log logger;
    private ClientProvider provider;
    private boolean blockUnsecureRequests;
    private SessionAuthenticityTokenProvider sessionAuthenticityTokenProvider;
    private SubjectCreator subjectCreator;
    private ResourceOwnerNameProvider resourceOwnerNameProvider;

    public AbstractClientService(Log logger) {
        this.logger = logger;
    }

    public void setDataProvider(ClientProvider provider) {
        this.provider = provider;
    }

    public void setResourceOwnerNameProvider(ResourceOwnerNameProvider resourceOwnerNameProvider) {
        this.resourceOwnerNameProvider = resourceOwnerNameProvider;
    }

    public void setSessionAuthenticityTokenProvider(SessionAuthenticityTokenProvider sessionAuthenticityTokenProvider) {
        this.sessionAuthenticityTokenProvider = sessionAuthenticityTokenProvider;
    }

    public void setSubjectCreator(SubjectCreator creator) {
        this.subjectCreator = creator;
    }

    public void setBlockUnsecureRequests(boolean blockUnsecureRequests) {
        this.blockUnsecureRequests = blockUnsecureRequests;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    protected ClientProvider getDataProvider() {
        return this.provider;
    }

    protected UserSubject createUserSubject(SecurityContext securityContext) {
        UserSubject subject = null;
        if (this.subjectCreator != null && (subject = this.subjectCreator.createUserSubject(this.getMessageContext())) != null) {
            return subject;
        }
        subject = (UserSubject)this.getMessageContext().getContent(UserSubject.class);
        if (subject != null) {
            return subject;
        }
        return OAuthUtil.newSubject(securityContext);
    }

    protected SecurityContext getAndValidateSecurityContext() {
        MessageContext mc = this.getMessageContext();
        SecurityContext securityContext = (SecurityContext)mc.get(SecurityContext.class);
        if (securityContext == null) {
            securityContext = (SecurityContext)mc.get((Object)SecurityContext.class.getName());
        }
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        this.checkTransportSecurity();
        return securityContext;
    }

    protected void checkTransportSecurity() {
        if (!this.mc.getSecurityContext().isSecure()) {
            this.logger.warn("Unsecure HTTP, Transport Layer Security is recommended", new Object[0]);
            if (this.blockUnsecureRequests) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
        }
    }

    protected void personalizeData(ClientRegistrationData data, UserSubject userSubject) {
        if (this.resourceOwnerNameProvider != null) {
            data.setEndUserName(this.resourceOwnerNameProvider.getName(userSubject));
        }
    }

    protected void addAuthenticityTokenToSession(ClientRegistrationData data, MultivaluedMap<String, String> params, UserSubject subject) {
        String sessionToken;
        if (this.sessionAuthenticityTokenProvider != null) {
            sessionToken = this.sessionAuthenticityTokenProvider.createSessionToken(this.getMessageContext(), params, subject);
        } else {
            HttpSession session = this.mc.getHttpServletRequest().getSession();
            sessionToken = (String)session.getAttribute("session_authenticity_token");
            if (!Strings.isValid((String)sessionToken)) {
                sessionToken = UUID.randomUUID().toString();
                session.setAttribute("session_authenticity_token", (Object)sessionToken);
            }
        }
        data.setAuthenticityToken(sessionToken);
    }

    protected boolean compareRequestAndSessionTokens(String requestToken, UserSubject subject) {
        String sessionToken;
        MessageContext mc = this.getMessageContext();
        if (this.sessionAuthenticityTokenProvider != null) {
            sessionToken = this.sessionAuthenticityTokenProvider.removeSessionToken(mc, mc.getHttpHeaders().getRequestHeaders(), subject);
        } else {
            HttpSession session = mc.getHttpServletRequest().getSession();
            sessionToken = (String)session.getAttribute("session_authenticity_token");
            if (sessionToken != null) {
                session.removeAttribute("session_authenticity_token");
            }
        }
        if (sessionToken == null || !Strings.isValid((String)sessionToken)) {
            return false;
        }
        return sessionToken.equals(requestToken);
    }
}

