/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.applicability;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.applicability.ApplicabilityBranchConfig;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchViewToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.rest.model.ApplicabilityUiEndpoint;

@Path(value="applicui")
public class ApplicabilityUiEndpointImpl
implements ApplicabilityUiEndpoint {
    @Context
    private UriInfo uriInfo;
    private final OrcsApplicability ops;

    public ApplicabilityUiEndpointImpl(OrcsApi orcsApi) {
        this.ops = orcsApi.getApplicabilityOps();
    }

    @GET
    @Produces(value={"text/html"})
    public Response get() {
        try {
            String basePath = this.uriInfo.getAbsolutePath().toString();
            String url = String.valueOf(basePath) + "/config/plconfig.html";
            URI uri = new URI(url);
            return Response.seeOther((URI)uri).build();
        }
        catch (URISyntaxException ex) {
            throw new OseeCoreException("Exception ", (Throwable)ex);
        }
    }

    @GET
    @Path(value="branches")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchViewToken> getApplicabilityBranches() {
        return this.ops.getApplicabilityBranches();
    }

    @GET
    @Path(value="branch/{branch}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ApplicabilityBranchConfig getConfig(@PathParam(value="branch") BranchId branch, @QueryParam(value="showAll") @DefaultValue(value="false") Boolean showAll) {
        return this.ops.getConfig(branch, showAll.booleanValue());
    }

    public String convertConfigToArtifact(BranchId branch) {
        return this.ops.convertConfigToArtifact(branch);
    }
}

