/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.client.internal.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.orcs.rest.client.QueryBuilder;
import org.eclipse.osee.orcs.rest.client.internal.search.PredicateFactory;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryExecutor;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryOptions;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.RequestType;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResult;

public class QueryBuilderImpl
implements QueryBuilder {
    private final PredicateFactory predicateFactory;
    private final BranchId branch;
    private final QueryOptions options;
    private final List<Predicate> predicates;
    private final QueryExecutor executor;

    public QueryBuilderImpl(BranchId branch, List<Predicate> predicates, QueryOptions options, PredicateFactory predicateFactory, QueryExecutor executor) {
        this.branch = branch;
        this.predicates = predicates;
        this.options = options;
        this.predicateFactory = predicateFactory;
        this.executor = executor;
    }

    @Override
    public QueryBuilder includeDeleted() {
        return this.includeDeleted(true);
    }

    @Override
    public QueryBuilder includeDeleted(boolean enabled) {
        this.options.setIncludeDeleted(enabled);
        return this;
    }

    @Override
    public boolean areDeletedIncluded() {
        return this.options.areDeletedIncluded();
    }

    @Override
    public QueryBuilder fromTransaction(TransactionId transaction) {
        this.options.setFromTransaction(transaction);
        return this;
    }

    @Override
    public TransactionId getFromTransaction() {
        return this.options.getFromTransaction();
    }

    @Override
    public QueryBuilder headTransaction() {
        this.options.setHeadTransaction();
        return this;
    }

    @Override
    public boolean isHeadTransaction() {
        return this.options.isHeadTransaction();
    }

    @Override
    public QueryBuilder excludeDeleted() {
        return this.includeDeleted(false);
    }

    @Override
    public QueryBuilder andId(ArtifactId artifactId) {
        return this.andIds(Collections.singletonList(artifactId));
    }

    @Override
    public QueryBuilder andGuids(List<String> ids) {
        this.predicates.add(this.predicateFactory.createGuidSearch(ids));
        return this;
    }

    @Override
    public QueryBuilder andIds(Collection<? extends ArtifactId> artifactIds) {
        this.predicates.add(this.predicateFactory.createArtifactIdsSearch(artifactIds));
        return this;
    }

    @Override
    public QueryBuilder andIsOfType(ArtifactTypeId ... artifactType) {
        return this.andIsOfType(Arrays.asList(artifactType));
    }

    @Override
    public QueryBuilder andIsOfType(Collection<? extends ArtifactTypeId> artifactTypes) {
        this.predicates.add(this.predicateFactory.createIsOfTypeSearch(artifactTypes));
        return this;
    }

    @Override
    public QueryBuilder andTypeEquals(ArtifactTypeId ... artifactType) {
        return this.andTypeEquals(Arrays.asList(artifactType));
    }

    @Override
    public QueryBuilder andTypeEquals(Collection<? extends ArtifactTypeId> artifactTypes) {
        this.predicates.add(this.predicateFactory.createTypeEqualsSearch(artifactTypes));
        return this;
    }

    @Override
    public QueryBuilder andExists(AttributeTypeId ... attributeType) {
        return this.andExists(Arrays.asList(attributeType));
    }

    @Override
    public QueryBuilder andExists(Collection<? extends AttributeTypeId> attributeTypes) {
        this.predicates.add(this.predicateFactory.createAttributeExistsSearch(attributeTypes));
        return this;
    }

    @Override
    public QueryBuilder andNotExists(AttributeTypeId attributeType) {
        this.predicates.add(this.predicateFactory.createAttributeNotExistsSearch(Collections.singleton(attributeType)));
        return this;
    }

    @Override
    public QueryBuilder andNotExists(Collection<? extends AttributeTypeId> attributeTypes) {
        this.predicates.add(this.predicateFactory.createAttributeNotExistsSearch(attributeTypes));
        return this;
    }

    @Override
    public QueryBuilder andExists(IRelationType relationType) {
        this.predicates.add(this.predicateFactory.createRelationExistsSearch(Collections.singleton(relationType)));
        return this;
    }

    @Override
    public QueryBuilder andExists(RelationTypeSide relationTypeSide) {
        this.predicates.add(this.predicateFactory.createRelationTypeSideExistsSearch(relationTypeSide));
        return this;
    }

    @Override
    public QueryBuilder andNotExists(RelationTypeSide relationTypeSide) {
        this.predicates.add(this.predicateFactory.createRelationTypeSideNotExistsSearch(relationTypeSide));
        return this;
    }

    @Override
    public QueryBuilder andNotExists(IRelationType relationType) {
        this.predicates.add(this.predicateFactory.createRelationNotExistsSearch(Collections.singleton(relationType)));
        return this;
    }

    @Override
    public QueryBuilder andNameEquals(String artifactName) {
        return this.and((AttributeTypeId)CoreAttributeTypes.Name, artifactName, new QueryOption[0]);
    }

    @Override
    public QueryBuilder and(AttributeTypeId attributeType, Collection<String> values, QueryOption ... options) {
        this.predicates.add(this.predicateFactory.createAttributeTypeSearch(Collections.singleton(attributeType), values, options));
        return this;
    }

    @Override
    public QueryBuilder and(AttributeTypeId attributeType, String value, QueryOption ... options) {
        return this.and(Collections.singleton(attributeType), value, options);
    }

    @Override
    public QueryBuilder and(Collection<? extends AttributeTypeId> attributeTypes, String value, QueryOption ... options) {
        this.predicates.add(this.predicateFactory.createAttributeTypeSearch(attributeTypes, value, options));
        return this;
    }

    @Override
    public QueryBuilder andRelatedTo(RelationTypeSide relationTypeSide, ArtifactId ... artifacts) {
        return this.andRelatedTo(relationTypeSide, Arrays.asList(artifacts));
    }

    @Override
    public QueryBuilder andRelatedTo(RelationTypeSide relationTypeSide, Collection<ArtifactId> artifactIds) {
        this.predicates.add(this.predicateFactory.createRelatedToSearch(relationTypeSide, artifactIds));
        return this;
    }

    @Override
    public SearchResult getSearchResult(RequestType request) {
        QueryOptions qOptions = this.options.clone();
        return this.executor.getResults(request, this.branch, this.predicates, qOptions);
    }

    @Override
    public int getCount() {
        QueryOptions qOptions = this.options.clone();
        return this.executor.getCount(this.branch, this.predicates, qOptions);
    }

    @Override
    public List<ArtifactId> getIds() {
        return this.getSearchResult(RequestType.IDS).getIds();
    }

    @Override
    public QueryBuilder getQueryBuilder() {
        return this;
    }
}

