/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.resolvers;

import java.util.Collection;
import java.util.List;
import org.eclipse.define.api.importing.ReqNumbering;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.osee.define.rest.importing.resolvers.IRoughArtifactTranslator;
import org.eclipse.osee.define.rest.importing.resolvers.NewArtifactImportResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class DoorsIdResolver
extends NewArtifactImportResolver {
    private final boolean createNewIfNotExist;

    public DoorsIdResolver(TransactionBuilder transaction, IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, boolean createNewIfNotExist, boolean deleteUnmatchedArtifacts) {
        super(transaction, translator, primaryArtifactType, secondaryArtifactType);
        this.createNewIfNotExist = createNewIfNotExist;
    }

    public ArtifactToken resolve(RoughArtifact roughArtifact, BranchId branch, ArtifactId realParentId, ArtifactId rootId) {
        ArtifactToken realArtifact = this.findExistingArtifact(roughArtifact, branch);
        if (realArtifact.isValid()) {
            this.getTranslator().translate(this.transaction, roughArtifact, (ArtifactId)realArtifact);
        }
        if (realArtifact.isInvalid() && this.createNewIfNotExist) {
            ArtifactReadable rootArtifact = roughArtifact.getOrcsApi().getQueryFactory().fromBranch(branch).andId(rootId).getArtifact();
            ArtifactToken parentArtifact = this.findParentArtifact(roughArtifact, branch, rootArtifact);
            if (parentArtifact != null) {
                ArtifactTypeToken artifactType = this.getArtifactType(roughArtifact);
                ArtifactToken createdArt = this.transaction.createArtifact(artifactType, roughArtifact.getName(), roughArtifact.getGuid());
                this.getTranslator().translate(this.transaction, roughArtifact, (ArtifactId)createdArt);
                this.transaction.relate((ArtifactId)parentArtifact, (RelationTypeToken)CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)createdArt);
            } else {
                roughArtifact.getResults().warningf("Doors ID resolver cant find parent. roughArtifactifact: [%s]. Doors Hierarchy: [%s]", new Object[]{roughArtifact.getName(), roughArtifact.getAttributes().getSoleAttributeValue("Doors Hierarchy")});
            }
        }
        return null;
    }

    private ArtifactToken findExistingArtifact(RoughArtifact roughArtifact, BranchId branch) {
        Collection doorsIDs = roughArtifact.getAttributes().getAttributeValueList(CoreAttributeTypes.DoorsId.getName());
        doorsIDs.remove(roughArtifact.getName());
        if (doorsIDs.size() < 1) {
            return null;
        }
        return roughArtifact.getOrcsApi().getQueryFactory().fromBranch(branch).andAttributeIs((AttributeTypeId)CoreAttributeTypes.DoorsId, (String)doorsIDs.iterator().next()).asArtifactTokenOrSentinel();
    }

    private ArtifactToken findParentArtifact(RoughArtifact roughArtifact, BranchId branch, ArtifactReadable rootId) {
        String doorsHierarchy = roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsHierarchy.getName());
        ReqNumbering reqNumber = new ReqNumbering(doorsHierarchy, true);
        String reqParent = reqNumber.getParentString();
        reqParent = new ReqNumbering(reqParent, true).getParentString();
        List results = roughArtifact.getOrcsApi().getQueryFactory().fromBranch(branch).andAttributeIs((AttributeTypeId)CoreAttributeTypes.DoorsHierarchy, reqParent).asArtifactTokens();
        while (results.size() == 0 && reqParent.length() > 3) {
            reqParent = new ReqNumbering(reqParent, true).getParentString();
            results = roughArtifact.getOrcsApi().getQueryFactory().fromBranch(branch).andAttributeIs((AttributeTypeId)CoreAttributeTypes.DoorsHierarchy, reqParent).asArtifactTokens();
        }
        for (ArtifactToken artifact : results) {
            ArtifactReadable possibleParent = roughArtifact.getOrcsApi().getQueryFactory().fromBranch(branch).andId((ArtifactId)artifact).getArtifact();
            if (!possibleParent.isDescendantOf((ArtifactToken)rootId)) continue;
            return artifact;
        }
        return null;
    }
}

