/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.io.ByteSource;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.security.OAuthClient;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthClientCredential;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthTypes;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class ClientArtifact
extends BaseIdentity<String>
implements OAuthClient {
    private final ArtifactReadable artifact;
    private final OAuthClientCredential credential;
    private ByteSource logoSupplier;

    public ClientArtifact(ArtifactReadable artifact, OAuthClientCredential credential) {
        super((Object)artifact.getGuid());
        this.credential = credential;
        this.artifact = artifact;
    }

    public long getClientUuid() {
        return this.credential.getClientId();
    }

    public long getSubjectId() {
        return this.credential.getSubjectId();
    }

    public String getApplicationName() {
        return this.artifact.getName();
    }

    public String getApplicationDescription() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description);
    }

    public String getApplicationWebUri() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)OAuthTypes.OAuthClientWebsiteUri);
    }

    public String getApplicationLogoUri() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)OAuthTypes.OAuthClientLogoUri);
    }

    public boolean isConfidential() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeToken)OAuthTypes.OAuthClientIsConfidential);
    }

    public List<String> getAllowedGrantTypes() {
        return this.artifact.getAttributeValues((AttributeTypeToken)OAuthTypes.OAuthClientAuthorizedGrantType);
    }

    public List<String> getRedirectUris() {
        return this.artifact.getAttributeValues((AttributeTypeToken)OAuthTypes.OAuthClientAuthorizedRedirectUri);
    }

    public List<String> getRegisteredScopes() {
        return this.artifact.getAttributeValues((AttributeTypeToken)OAuthTypes.OAuthClientAuthorizedScope);
    }

    public List<String> getRegisteredAudiences() {
        return this.artifact.getAttributeValues((AttributeTypeToken)OAuthTypes.OAuthClientAuthorizedAudience);
    }

    public Map<String, String> getProperties() {
        String data = (String)this.artifact.getSoleAttributeValue((AttributeTypeToken)OAuthTypes.OAuthClientProperties, null);
        if (Strings.isValid((String)data)) {
            return (Map)JsonUtil.readValue((String)data, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        return Collections.emptyMap();
    }

    public String getClientId() {
        return this.credential.getClientKey();
    }

    public String getClientSecret() {
        return this.credential.getClientSecret();
    }

    public List<String> getApplicationCertificates() {
        return this.credential.getClientCertificates();
    }

    public boolean hasApplicationLogoSupplier() {
        return this.artifact.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.ImageContent) > 0;
    }

    public ByteSource getApplicationLogoSupplier() {
        return this.logoSupplier;
    }

    public void setApplicationLogoSupplier(ByteSource supplier) {
        this.logoSupplier = supplier;
    }

    public InputStream getInput() {
        return (InputStream)this.artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ImageContent);
    }
}

