/*******************************************************************************
 * Copyright (c) 2013 Boeing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Boeing - initial API and implementation
 *******************************************************************************/
package org.eclipse.osee.orcs.core.ds.criteria;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;

/**
 * @author Roberto E. Escobar
 */
public class CriteriaBranchAncestorOf extends Criteria implements BranchCriteria {

   private final BranchId child;

   public CriteriaBranchAncestorOf(BranchId child) {
      super();
      this.child = child;
   }

   public BranchId getChild() {
      return child;
   }

   @Override
   public void checkValid(Options options) {
      Conditions.checkNotNull(getChild(), "Child branch");
   }

   @Override
   public String toString() {
      return "CriteriaBranchAncestorOf [child=" + child + "]";
   }

}
