/*******************************************************************************
 * Copyright (c) 2015 Boeing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Boeing - initial API and implementation
 *******************************************************************************/
package org.eclipse.osee.ats.api.task;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;

/**
 * @author Donald G. Dunne
 */
@Path("task")
public interface AtsTaskEndpointApi {

   @PUT
   @Consumes(MediaType.APPLICATION_JSON)
   @Produces(MediaType.APPLICATION_JSON)
   public JaxAtsTasks create(NewTaskDatas newTaskDatas);

   @GET
   @Path("{taskId}")
   @Produces(MediaType.APPLICATION_JSON)
   public JaxAtsTask get(@PathParam("taskId") long taskId);

   @DELETE
   @Path("{taskId}")
   public void delete(@PathParam("taskId") long taskId);

   @PUT
   @Path("chgRpt")
   @Consumes(MediaType.APPLICATION_JSON)
   @Produces(MediaType.APPLICATION_JSON)
   public ChangeReportTaskData create(ChangeReportTaskData data);

}
