/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.integration.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class OseeDslSegmentParser {
    public String getStartTag(ArtifactToken artifact, IOseeBranch branch) {
        return OseeDslSegmentParser.getSegmentTag("start", artifact, branch);
    }

    public String getEndTag(ArtifactToken artifact, IOseeBranch branch) {
        return OseeDslSegmentParser.getSegmentTag("end", artifact, branch);
    }

    private static String getSegmentTag(String tagPrefix, ArtifactToken artifact, IOseeBranch branch) {
        Conditions.checkNotNull((Object)artifact, (String)"artifact");
        Conditions.checkNotNull((Object)branch, (String)"branch");
        return String.format("//@%s_artifact branch/%s/artifact/%s/ (%s:%s)", tagPrefix, branch.getId(), artifact.getGuid(), branch.getName(), artifact.getName());
    }

    public Collection<OseeDslSegment> getSegments(String source) {
        return this.getSegments(this.getTagLocations(source));
    }

    public Collection<OseeDslSegment> getSegments(Collection<TagLocation> tagLocations) {
        Conditions.checkNotNull(tagLocations, (String)"tagLocations");
        ArrayList<OseeDslSegment> segments = new ArrayList<OseeDslSegment>();
        Stack<TagLocation> segmentStack = new Stack<TagLocation>();
        for (TagLocation segment : tagLocations) {
            if (segment.isStartTag()) {
                segmentStack.push(segment);
                continue;
            }
            if (!this.matches((TagLocation)segmentStack.peek(), segment)) continue;
            TagLocation startSeg = (TagLocation)segmentStack.pop();
            this.processData(segments, startSeg, segment);
        }
        if (!segmentStack.isEmpty()) {
            throw new OseeStateException("Found unmatched segments", new Object[0]);
        }
        return segments;
    }

    private void processData(Collection<OseeDslSegment> segments, TagLocation startSeg, TagLocation stopSeg) {
        String artifactGuid = startSeg.getArtifactGuid();
        int startAt = startSeg.end();
        int endAt = stopSeg.start();
        segments.add(new OseeDslSegment(startSeg.getBranch(), artifactGuid, startAt, endAt));
    }

    private boolean matches(TagLocation seg1, TagLocation seg2) {
        return seg1.getBranch() == seg2.getBranch() && seg1.getArtifactGuid().equals(seg2.getArtifactGuid());
    }

    public Collection<TagLocation> getTagLocations(String source) {
        Conditions.checkNotNull((Object)source, (String)"artifact source data");
        ArrayList<TagLocation> segments = new ArrayList<TagLocation>();
        Pattern pattern = Pattern.compile("\\s?//@(.*?)_artifact\\s+branch/(.*?)/artifact/(.*?)/\\s+\\(.*?\\)");
        Matcher matcher = pattern.matcher(source);
        String artifactGuid = null;
        String tag = null;
        int tagStart = -1;
        int tagEnd = -1;
        while (matcher.find()) {
            tagStart = matcher.start();
            tagEnd = matcher.end();
            tag = matcher.group(1);
            BranchId branch = BranchId.valueOf((String)matcher.group(2));
            artifactGuid = matcher.group(3);
            if (!Strings.isValid((String)tag) || !branch.isValid() || !Strings.isValid((String)artifactGuid)) continue;
            boolean isStartTag = tag.equalsIgnoreCase("start");
            segments.add(new TagLocation(isStartTag, branch, artifactGuid, tagStart, tagEnd));
        }
        return segments;
    }

    public static final class OseeDslSegment
    implements HasBranch {
        private final BranchId branch;
        private final String artifactGuid;
        private final int start;
        private final int end;

        public OseeDslSegment(BranchId branch, String artifactGuid, int start, int end) {
            this.branch = branch;
            this.artifactGuid = artifactGuid;
            this.start = start;
            this.end = end;
        }

        public BranchId getBranch() {
            return this.branch;
        }

        public String getArtifactGuid() {
            return this.artifactGuid;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.artifactGuid == null ? 0 : this.artifactGuid.hashCode());
            result = 31 * result + this.branch.hashCode();
            result = 31 * result + this.end;
            result = 31 * result + this.start;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OseeDslSegment other = (OseeDslSegment)obj;
            if (this.artifactGuid == null ? other.artifactGuid != null : !this.artifactGuid.equals(other.artifactGuid)) {
                return false;
            }
            if (!this.isOnSameBranch(other)) {
                return false;
            }
            if (this.end != other.end) {
                return false;
            }
            return this.start == other.start;
        }

        public String toString() {
            return "OseeDslSegment [branchId=" + this.branch + ", artifactId=" + this.artifactGuid + ", start=" + this.start + ", end=" + this.end + "]";
        }
    }

    public static final class TagLocation {
        private final boolean isStartTag;
        private final BranchId branch;
        private final String artifactGuid;
        private final int start;
        private final int end;

        public TagLocation(boolean isStartTag, BranchId branch, String artifactGuid, int start, int end) {
            this.isStartTag = isStartTag;
            this.branch = branch;
            this.artifactGuid = artifactGuid;
            this.start = start;
            this.end = end;
        }

        public boolean isStartTag() {
            return this.isStartTag;
        }

        public BranchId getBranch() {
            return this.branch;
        }

        public String getArtifactGuid() {
            return this.artifactGuid;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public String toString() {
            return "OseeDslSegment [isStartTag=" + this.isStartTag + ", branchUuid=" + this.branch + ", artifactGuid=" + this.artifactGuid + ", start=" + this.start + ", end=" + this.end + "]";
        }
    }
}

