/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.Attribute;
import org.eclipse.osee.ats.api.workflow.NewActionData;
import org.eclipse.osee.ats.api.workflow.NewActionResult;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;

@Path(value="action")
public interface AtsActionEndpointApi {
    @GET
    @Produces(value={"text/html"})
    public String get();

    @Path(value="{ids}")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkItem> getAction(@PathParam(value="ids") String var1);

    @Path(value="{ids}/details")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkItem> getActionDetails(@PathParam(value="ids") String var1);

    @Path(value="{ids}/child")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkItem> getActionChildren(@PathParam(value="ids") String var1);

    @Path(value="{ids}/legacy/state")
    @GET
    public String getActionStateFromLegacyPcrId(@PathParam(value="ids") String var1);

    @Path(value="{ids}/state")
    @GET
    public String getActionState(@PathParam(value="ids") String var1);

    @Path(value="query")
    @GET
    @Produces(value={"application/json"})
    public Set<IAtsWorkItem> query(UriInfo var1);

    @Path(value="query/legacyId")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkItem> query(@QueryParam(value="ids") String var1);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public NewActionResult createAction(NewActionData var1);

    @Path(value="createEmpty")
    @POST
    @Produces(value={"application/json"})
    public String createEmptyAction(@QueryParam(value="userId") String var1, @QueryParam(value="ai") String var2, @QueryParam(value="title") String var3);

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createAction(MultivaluedMap<String, String> var1);

    @Path(value="{actionId}/attributeType/{attrTypeId}")
    @GET
    @Produces(value={"application/json"})
    public Attribute getActionAttributeByType(@PathParam(value="actionId") String var1, @PathParam(value="attrTypeId") String var2);

    @Path(value="{actionId}/attributeType/{attrTypeId}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Attribute setActionAttributeByType(@PathParam(value="actionId") String var1, @PathParam(value="attrTypeId") String var2, List<String> var3);

    @Path(value="{id}/cancel")
    @GET
    @Produces(value={"text/html"})
    public Response cancelAction(@PathParam(value="id") String var1) throws URISyntaxException;

    @Path(value="{workItemId}/changeType/{changeType}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Collection<ArtifactToken> setByArtifactToken(@PathParam(value="workItemId") String var1, @PathParam(value="changeType") String var2, Collection<ArtifactToken> var3);

    @GET
    @Path(value="{id}/UnreleasedVersions")
    @Produces(value={"application/json"})
    public List<String> getUnreleasedVersionNames(@PathParam(value="id") String var1);

    @GET
    @Path(value="{id}/TransitionToStates")
    @Produces(value={"application/json"})
    public List<String> getTransitionToStateNames(@PathParam(value="id") String var1);

    @GET
    @Path(value="{id}/assocArt/{attrTypeId}")
    @Produces(value={"application/json"})
    public List<String> getRelatedRequirements(@PathParam(value="workflowId") ArtifactId var1, @PathParam(value="relatedReqs") AttributeTypeId var2, @QueryParam(value="versionType") AttributeTypeId var3);
}

