/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.agile;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.agile.AgileItem;
import org.eclipse.osee.ats.api.agile.AgileSprintData;
import org.eclipse.osee.ats.api.agile.AgileWriterResult;
import org.eclipse.osee.ats.api.agile.JaxAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.agile.JaxAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxNewAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxNewAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxNewAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.JaxNewAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.agile.kanban.JaxKbSprint;
import org.eclipse.osee.ats.api.agile.program.JaxProgramBacklogItemUpdate;
import org.eclipse.osee.ats.api.agile.program.JaxProgramFeatureUpdate;
import org.eclipse.osee.ats.api.agile.program.UiGridProgram;
import org.eclipse.osee.ats.api.agile.sprint.SprintConfigurations;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.util.ILineChart;
import org.eclipse.osee.ats.api.util.RestResult;
import org.eclipse.osee.ats.api.workflow.JaxAtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

@Path(value="agile")
public interface AgileEndpointApi {
    @GET
    public String get();

    @GET
    @Path(value="program/token")
    @Produces(value={"application/json"})
    public List<JaxAtsObject> getProgramTokens() throws Exception;

    @GET
    @Path(value="program/{programId}/token")
    @Produces(value={"application/json"})
    public JaxAtsObject getProgramToken(@PathParam(value="programId") ArtifactId var1);

    @GET
    @Path(value="program/{programId}/atw")
    @Produces(value={"application/json"})
    public String getProgramAtw(@PathParam(value="programId") long var1) throws Exception;

    @GET
    @Path(value="program/{programId}/uigrid")
    @Produces(value={"application/json"})
    public UiGridProgram getProgramItems(@PathParam(value="programId") long var1) throws Exception;

    @POST
    @Path(value="program/{programId}/backlogitem")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JaxProgramBacklogItemUpdate updateProgramBacklogItem(@PathParam(value="programId") long var1, JaxProgramBacklogItemUpdate var3);

    @DELETE
    @Path(value="programbacklogitem/{programBacklogItemId}")
    public RestResult deleteProgramBacklogItem(@PathParam(value="programBacklogItemId") long var1);

    @POST
    @Path(value="program/{programId}/feature")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JaxProgramFeatureUpdate updateProgramFeature(@PathParam(value="programId") long var1, JaxProgramFeatureUpdate var3);

    @DELETE
    @Path(value="programfeature/{programFeatureId}")
    public RestResult deleteProgramFeature(@PathParam(value="programFeatureId") long var1);

    @GET
    @Path(value="team/token")
    @Produces(value={"application/json"})
    public List<JaxAtsObject> getTeamTokens() throws Exception;

    @GET
    @Path(value="team")
    @Produces(value={"application/json"})
    public List<JaxAgileTeam> team() throws Exception;

    @GET
    @Path(value="team/{teamId}")
    @Produces(value={"application/json"})
    public JaxAgileTeam getTeam(@PathParam(value="teamId") long var1);

    @GET
    @Path(value="team/{teamId}/token")
    @Produces(value={"application/json"})
    public ArtifactToken getTeamToken(@PathParam(value="teamId") ArtifactId var1);

    @GET
    @Path(value="team/{teamId}/feature")
    @Produces(value={"application/json"})
    public List<JaxAgileFeatureGroup> getFeatureGroups(@PathParam(value="teamId") long var1);

    @GET
    @Path(value="team/{teamId}/ai")
    @Produces(value={"application/json"})
    public List<IAtsActionableItem> getActionableAis(@PathParam(value="teamId") ArtifactId var1);

    @GET
    @Path(value="team/{teamId}/member")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getTeamMembers(@PathParam(value="teamId") ArtifactId var1);

    @GET
    @Path(value="team/{teamId}/memberOther")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getOtherMembers(@PathParam(value="teamId") ArtifactId var1);

    @Path(value="team/{teamId}/workpackage")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkPackage> getWorkPackages(@PathParam(value="teamId") ArtifactId var1);

    @GET
    @Path(value="team/{teamId}/feature/{featureId}")
    @Produces(value={"application/json"})
    public JaxAgileFeatureGroup getFeatureGroup(long var1, long var3);

    @GET
    @Path(value="team/{teamId}/backlog")
    @Produces(value={"application/json"})
    public JaxAgileBacklog getBacklog(@PathParam(value="teamId") long var1);

    @GET
    @Path(value="team/{teamId}/backlog/token")
    @Produces(value={"application/json"})
    public ArtifactToken getBacklogToken(@PathParam(value="teamId") ArtifactId var1);

    @GET
    @Path(value="team/{teamId}/backlog/item")
    @Produces(value={"application/json"})
    public List<AgileItem> getBacklogItems(@PathParam(value="teamId") long var1);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/item")
    @Produces(value={"application/json"})
    public List<AgileItem> getSprintItems(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint")
    @Produces(value={"application/json"})
    public List<JaxAgileSprint> getSprints(@PathParam(value="teamId") long var1);

    @GET
    @Path(value="team/{teamId}/sprint/token")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getSprintsTokens(@PathParam(value="teamId") long var1);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}")
    @Produces(value={"application/json"})
    public JaxAgileSprint getSprint(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @POST
    @Path(value="team/{teamId}/sprint/{sprintId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AgileSprintData updateSprint(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3, AgileSprintData var5);

    @POST
    @Path(value="team/{teamId}/sprint/{sprintId}/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SprintConfigurations updateSprintConfig(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3, SprintConfigurations var5);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/kb")
    @Produces(value={"application/json"})
    public JaxKbSprint getSprintItemsForKb(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/kb/story")
    @Produces(value={"application/json"})
    public JaxKbSprint getSprintItemsForKbByStory(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/config")
    @Produces(value={"application/json"})
    public SprintConfigurations getSprintConfig(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprintcurrent")
    @Produces(value={"application/json"})
    public JaxAgileSprint getSprintCurrent(@PathParam(value="teamId") long var1);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/summary")
    @Produces(value={"text/html"})
    public String getSprintSummary(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/data")
    @Produces(value={"application/json"})
    public AgileSprintData getSprintData(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/data/table")
    @Produces(value={"text/html"})
    public String getSprintDataTable(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/burndown?type=best")
    @Produces(value={"text/html"})
    public String getBurndownBest(@PathParam(value="teamId") long var1);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/burndown/chart/ui")
    @Produces(value={"text/html"})
    public String getSprintBurndownChartUi(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/burndown/chart/data")
    @Produces(value={"application/json"})
    public ILineChart getSprintBurndownChartData(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/storereports")
    @Produces(value={"application/json"})
    public XResultData storeSprintReports(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/burnup/chart/ui")
    @Produces(value={"text/html"})
    public String getSprintBurnupChartUi(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/burnup/chart/data")
    @Produces(value={"application/json"})
    public ILineChart getSprintBurnupChartData(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/world")
    @Produces(value={"application/json"})
    public JaxAtsObjects getSprintItemsAsJax(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/world/ui")
    @Produces(value={"text/html"})
    public Response getSprintItemsUI(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @GET
    @Path(value="team/{teamId}/sprint/{sprintId}/world/ui/{customizeGuid}")
    @Produces(value={"text/html"})
    public Response getSprintItemsUICustomized(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3, @PathParam(value="customizeGuid") String var5);

    @POST
    @Path(value="team")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createTeam(JaxNewAgileTeam var1);

    @PUT
    @Path(value="team")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateTeam(JaxAgileTeam var1);

    @POST
    @Path(value="team/{teamId}/feature")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFeatureGroup(@PathParam(value="teamId") long var1, JaxNewAgileFeatureGroup var3);

    @POST
    @Path(value="program/{programId}/feature")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createProgramFeature(Long var1, JaxNewAgileProgramFeature var2);

    @POST
    @Path(value="team/{teamId}/sprint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createSprint(@PathParam(value="teamId") long var1, JaxNewAgileSprint var3);

    @POST
    @Path(value="team/{teamId}/backlog")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createBacklog(@PathParam(value="teamId") long var1, JaxNewAgileBacklog var3);

    @PUT
    @Path(value="team/{teamId}/backlog")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateBacklog(long var1, JaxAgileBacklog var3);

    @PUT
    @Path(value="item/{itemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AgileWriterResult updateAgileItem(@PathParam(value="itemId") long var1, JaxAgileItem var3);

    @PUT
    @Path(value="items")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AgileWriterResult updateItems(JaxAgileItem var1);

    @DELETE
    @Path(value="team/{teamId}/feature/{featureId}")
    public Response deleteFeatureGroup(@PathParam(value="teamId") long var1, @PathParam(value="featureId") long var3);

    @DELETE
    @Path(value="team/{teamId}/sprint/{sprintId}")
    public Response deleteSprint(@PathParam(value="teamId") long var1, @PathParam(value="sprintId") long var3);

    @DELETE
    @Path(value="team/{teamId}")
    public Response deleteTeam(@PathParam(value="teamId") long var1);

    @PUT
    @Path(value="item/{itemId}/feature")
    public Response addFeatureGroup(@PathParam(value="itemId") long var1, String var3);

    @PUT
    @Path(value="item/{itemId}/unplanned")
    public Response setUnPlanned(@PathParam(value="itemId") long var1, boolean var3);

    @PUT
    @Path(value="item/{itemId}/points")
    public Response setPoints(@PathParam(value="itemId") long var1, String var3);
}

