/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class OseeCodeVersion {
    private static String version;
    private static String bundleVersion;
    public static Pattern BuildStrPattern;
    public static Pattern DevStrPattern;
    private static Long versionId;

    static {
        BuildStrPattern = Pattern.compile("([\\d]{1,2})\\.([\\d]{1,2})\\.([\\d]{1,2})\\.v([\\d]{12})-.*$");
        DevStrPattern = Pattern.compile("([\\d]{1,2})\\.([\\d]{1,2})\\.([\\d]{1,2})\\.qualifier");
    }

    private OseeCodeVersion() {
    }

    public static String getVersion() {
        String ver = version;
        if (!Strings.isValid((String)ver) && !Strings.isValid((String)(ver = System.getProperty("osee.version", "")))) {
            ver = OseeCodeVersion.getBundleVersion();
        }
        return ver;
    }

    public static Long getVersionId() {
        if (versionId == null) {
            versionId = OseeCodeVersion.computeVersionId();
        }
        return versionId;
    }

    static Long computeVersionId() {
        Long versionId = 0L;
        try {
            String devVersion = OseeCodeVersion.getVersion();
            boolean isDev = devVersion.toLowerCase().endsWith("development");
            String bundleVersion = OseeCodeVersion.getBundleVersion();
            Matcher m = BuildStrPattern.matcher(bundleVersion);
            if (m.find()) {
                String inc;
                String minor;
                String major = m.group(1);
                if (major.length() == 1) {
                    major = "0" + major;
                }
                if ((minor = m.group(2)).length() == 1) {
                    minor = "0" + minor;
                }
                if ((inc = m.group(3)).length() == 1) {
                    inc = "0" + inc;
                }
                String dayTimeStamp = m.group(4);
                int buildId = 0;
                if (bundleVersion.endsWith("-REL")) {
                    buildId = 1;
                } else if (bundleVersion.endsWith("-NR")) {
                    buildId = isDev ? 3 : 2;
                } else if (bundleVersion.endsWith("-DEV")) {
                    buildId = isDev ? 5 : 4;
                }
                String buildStr = String.format("%s%s%s%s%s", major, minor, inc, dayTimeStamp, buildId);
                versionId = Long.valueOf(buildStr);
            } else {
                m = DevStrPattern.matcher(bundleVersion);
                if (m.find()) {
                    String inc;
                    String minor;
                    String major = m.group(1);
                    if (major.length() == 1) {
                        major = "0" + major;
                    }
                    if ((minor = m.group(2)).length() == 1) {
                        minor = "0" + minor;
                    }
                    if ((inc = m.group(3)).length() == 1) {
                        inc = "0" + inc;
                    }
                    String buildStr = String.format("%s%s%s", major, minor, inc);
                    versionId = Long.valueOf(buildStr);
                }
            }
        }
        catch (Exception exception) {}
        return versionId;
    }

    public static String getBundleVersion() {
        Bundle bundle;
        String version = bundleVersion;
        if (!Strings.isValid((String)version) && (bundle = FrameworkUtil.getBundle(OseeCodeVersion.class)) != null && bundle.getVersion() != null) {
            version = bundle.getVersion().toString();
        }
        return version;
    }

    public static void setVersion(String version) {
        OseeCodeVersion.version = version;
    }

    public static void setBundleVersion(String bundleVersion) {
        OseeCodeVersion.bundleVersion = bundleVersion;
    }
}

