/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchViewToken;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.Id;

@JsonSerialize(as=Branch.class)
public class Branch
extends BranchViewToken
implements IOseeBranch {
    public static final Branch SENTINEL = new Branch(Id.SENTINEL, "Sentinel", ArtifactId.SENTINEL, TransactionId.SENTINEL, TransactionId.SENTINEL, BranchId.SENTINEL, false, null, null, false, ArtifactId.SENTINEL);
    private final ArtifactId associatedArtifact;
    private final TransactionId baselineTx;
    private final TransactionId parentTx;
    private final BranchId parentBranch;
    private final boolean isArchived;
    private final BranchState branchState;
    private final BranchType branchType;
    private final boolean inheritAccessControl;
    private final ArtifactId viewId;

    public Branch(Long id, String name, ArtifactId associatedArtifact, TransactionId baselineTx, TransactionId parentTx, BranchId parentBranch, boolean isArchived, BranchState branchState, BranchType branchType, boolean inheritAccessControl, ArtifactId viewId) {
        super(id, name, viewId);
        this.associatedArtifact = associatedArtifact;
        this.baselineTx = baselineTx;
        this.parentTx = parentTx;
        this.parentBranch = parentBranch;
        this.isArchived = isArchived;
        this.branchState = branchState;
        this.branchType = branchType;
        this.inheritAccessControl = inheritAccessControl;
        this.viewId = viewId;
    }

    public ArtifactId getAssociatedArtifact() {
        return this.associatedArtifact;
    }

    public TransactionId getBaselineTx() {
        return this.baselineTx;
    }

    public TransactionId getParentTx() {
        return this.parentTx;
    }

    public BranchId getParentBranch() {
        return this.parentBranch;
    }

    public boolean hasParentBranch() {
        return this.parentBranch.isValid();
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public BranchState getBranchState() {
        return this.branchState;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public boolean inheritAccessControl() {
        return this.inheritAccessControl;
    }

    @Override
    public ArtifactId getViewId() {
        return this.viewId;
    }
}

