/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.data.ArtifactTypeAttributeTypeMetaData;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Multiplicity;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.jdk.core.type.Id;

public final class AttributeMultiplicity
extends ConcurrentHashMap<AttributeTypeToken, ArtifactTypeAttributeTypeMetaData> {
    private static final long serialVersionUID = 1L;
    private final ArtifactTypeToken artifactType;

    public AttributeMultiplicity(Long id, NamespaceToken namespace, String name, boolean isAbstract, ArtifactTypeToken ... superTypes) {
        ArtifactTypeToken artifactType;
        this.artifactType = artifactType = ArtifactTypeToken.create(id, namespace, name, isAbstract, this, superTypes);
    }

    public AttributeMultiplicity any(AttributeTypeGeneric<?> attributeType, String defaultValue) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData(Multiplicity.ANY, defaultValue));
        return this;
    }

    public AttributeMultiplicity exactlyOne(AttributeTypeGeneric<?> attributeType, String defaultValue) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData(Multiplicity.EXACTLY_ONE, defaultValue));
        return this;
    }

    public AttributeMultiplicity exactlyOne(AttributeTypeGeneric<?> attributeType, String defaultValue, Long enumTypeId) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData(Multiplicity.ANY, defaultValue, enumTypeId));
        return this;
    }

    public AttributeMultiplicity zeroOrOne(AttributeTypeGeneric<?> attributeType, String defaultValue) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData(Multiplicity.ZERO_OR_ONE, defaultValue));
        return this;
    }

    public AttributeMultiplicity zeroOrOne(AttributeTypeGeneric<?> attributeType, String defaultValue, Long enumTypeId) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData(Multiplicity.ZERO_OR_ONE, defaultValue, enumTypeId));
        return this;
    }

    public AttributeMultiplicity atLeastOne(AttributeTypeGeneric<?> attributeType, String defaultValue, Long enumTypeId) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData(Multiplicity.AT_LEAST_ONE, defaultValue, enumTypeId));
        return this;
    }

    public AttributeMultiplicity atLeastOne(AttributeTypeGeneric<?> attributeType, String defaultValue) {
        this.put(attributeType, new ArtifactTypeAttributeTypeMetaData(Multiplicity.AT_LEAST_ONE, defaultValue));
        return this;
    }

    public Integer getMinimum(AttributeTypeToken attributeType) {
        return ((ArtifactTypeAttributeTypeMetaData)this.get(attributeType)).getMultiplicity().matches(new Id[]{Multiplicity.ANY, Multiplicity.ZERO_OR_ONE}) ? 0 : 1;
    }

    public Integer getMaximum(AttributeTypeToken attributeType) {
        return ((ArtifactTypeAttributeTypeMetaData)this.get(attributeType)).getMultiplicity().matches(new Id[]{Multiplicity.EXACTLY_ONE, Multiplicity.ZERO_OR_ONE}) ? 1 : Integer.MAX_VALUE;
    }

    public ArtifactTypeToken get() {
        return this.artifactType;
    }
}

