/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.applicability;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchViewToken;

public class ApplicabilityBranchConfig {
    BranchViewToken branch;
    Map<String, FeatureDefinition> featureIdToFeature = new HashMap<String, FeatureDefinition>();
    List<String> featuresOrdered = new LinkedList<String>();
    List<ArtifactToken> variants = new LinkedList<ArtifactToken>();
    List<String> variantsOrdered = new LinkedList<String>();
    List<Map<String, String>> featureToValueMaps = new LinkedList<Map<String, String>>();
    List<FeatureDefinition> features = new LinkedList<FeatureDefinition>();

    public void addFeature(FeatureDefinition fDef) {
        this.featureIdToFeature.put(fDef.getIdString(), fDef);
        this.featuresOrdered.add(fDef.getName());
        this.features.add(fDef);
    }

    public void addVariant(ArtifactToken variant) {
        this.variants.add(variant);
        this.variantsOrdered.add(variant.getName());
    }

    public BranchViewToken getBranch() {
        return this.branch;
    }

    public void setBranch(BranchViewToken branch) {
        this.branch = new BranchViewToken(branch.getId(), branch.getName(), branch.getViewId());
    }

    public List<ArtifactToken> getVariants() {
        return this.variants;
    }

    public void setVariants(List<ArtifactToken> variants) {
        this.variants = variants;
    }

    public void addFeatureToValueMap(Map<String, String> featureToValue) {
        this.featureToValueMaps.add(featureToValue);
    }

    public Map<String, String> getFeatureToValues(int index) {
        return this.featureToValueMaps.get(index);
    }

    public List<Map<String, String>> getFeatureToValueMaps() {
        return this.featureToValueMaps;
    }

    public List<String> getFeaturesOrdered() {
        return this.featuresOrdered;
    }

    public List<String> getVariantsOrdered() {
        return this.variantsOrdered;
    }

    public void setVariantsOrdered(List<String> variantsOrdered) {
        this.variantsOrdered = variantsOrdered;
    }

    public Map<String, FeatureDefinition> getFeatureIdToFeature() {
        return this.featureIdToFeature;
    }

    public void setFeatureIdToFeature(Map<String, FeatureDefinition> featureIdToFeature) {
        this.featureIdToFeature = featureIdToFeature;
    }

    public List<FeatureDefinition> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<FeatureDefinition> features) {
        this.features = features;
    }
}

