/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.core.query.AbstractAtsQueryImpl;
import org.eclipse.osee.ats.core.query.AtsAttributeQuery;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsQueryImpl
extends AbstractAtsQueryImpl {
    private final OrcsApi orcsApi;
    private QueryBuilder query;

    public AtsQueryImpl(AtsApi atsApi, OrcsApi orcsApi) {
        super(atsApi);
        this.orcsApi = orcsApi;
    }

    public Collection<? extends ArtifactToken> runQuery() {
        return this.query.getResults().getList();
    }

    public void createQueryBuilder() {
        if (this.query == null) {
            this.query = this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch());
        }
    }

    public void queryAnd(AttributeTypeId attrType, Collection<String> values) {
        this.query.and(attrType, values, new QueryOption[0]);
    }

    public void queryAndIsOfType(ArtifactTypeToken artifactType) {
        this.query.andIsOfType(new ArtifactTypeId[]{artifactType});
    }

    public List<ArtifactId> queryGetIds() {
        return this.query.asArtifactIds();
    }

    public void queryAndIsOfType(Collection<ArtifactTypeToken> artTypes) {
        this.query.andIsOfType(artTypes);
    }

    public void queryAnd(AttributeTypeId attrType, String value) {
        this.query.and(attrType, value, new QueryOption[0]);
    }

    public void queryAndRelatedToLocalIds(RelationTypeSide relationTypeSide, ArtifactId artId) {
        this.query.andRelatedTo(relationTypeSide, artId);
    }

    public void queryAndRelatedTo(RelationTypeSide relationTypeSide, List<ArtifactId> artifacts) {
        this.query.andRelatedTo(relationTypeSide, artifacts);
    }

    public void queryAnd(AttributeTypeId attrType, Collection<String> values, QueryOption[] queryOption) {
        this.query.and(attrType, values, queryOption);
    }

    public void queryAnd(AttributeTypeId attrType, String value, QueryOption[] queryOption) {
        this.query.and(attrType, value, queryOption);
    }

    public void queryAndIds(Collection<? extends ArtifactId> artIds) {
        this.query.andIds(artIds);
    }

    public void queryAndNotExists(RelationTypeSide relationTypeSide) {
        this.query.andRelationNotExists((IRelationType)relationTypeSide);
    }

    public void queryAndExists(RelationTypeSide relationTypeSide) {
        this.query.andRelationExists((RelationTypeId)relationTypeSide, relationTypeSide.getSide());
    }

    public List<ArtifactId> getWorkPackagesForColorTeam(String colorTeam) {
        LinkedList<ArtifactId> workPackageIds = new LinkedList<ArtifactId>();
        for (ArtifactReadable workPackageArt : this.query.andTypeEquals(new ArtifactTypeId[]{AtsArtifactTypes.WorkPackage}).andAttributeIs((AttributeTypeId)AtsAttributeTypes.ColorTeam, colorTeam).getResults()) {
            workPackageIds.add((ArtifactId)workPackageArt);
        }
        return workPackageIds;
    }

    public List<ArtifactId> getRelatedTeamWorkflowIdsBasedOnTeamDefsAisAndVersions(List<AtsAttributeQuery> teamWorkflowAttr) {
        AtsQueryImpl search = new AtsQueryImpl(this.atsApi, this.orcsApi);
        search.isOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow});
        if (this.teamDefIds != null && !this.teamDefIds.isEmpty()) {
            search.andTeam(new ArrayList(this.teamDefIds));
        }
        if (this.aiIds != null && !this.aiIds.isEmpty()) {
            search.andActionableItem(new ArrayList(this.aiIds));
        }
        if (this.versionId != null && this.versionId > 0L) {
            search.andVersion(this.versionId);
        }
        return new ArrayList<ArtifactId>(search.getItemIds());
    }

    protected void queryAndNotExists(AttributeTypeId attributeType) {
        this.query.andNotExists(attributeType);
    }

    protected void queryAndExists(AttributeTypeToken attributeType) {
        this.query.andExists(new AttributeTypeId[]{attributeType});
    }
}

