/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.rest.internal.config.TypeCountWriter;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.data.AttributeTypes;

@Path(value="typeCount")
public class ReportResource {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;

    public ReportResource(OrcsApi orcsApi, AtsApi atsApi) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getTypeCount(final @QueryParam(value="branch") BranchId branch, final @QueryParam(value="artTypes") List<Long> artTypes, final @QueryParam(value="attrTypes") List<Long> attrTypes) {
        List<ChangeItem> changes = this.getChanges(branch);
        final HashSet<Long> newArts = new HashSet<Long>();
        final HashSet<Long> modArts = new HashSet<Long>();
        final HashSet<Long> deletedArts = new HashSet<Long>();
        HashMap<Integer, Pair<ChangeItem, Set<ChangeItem>>> artToChanges = new HashMap<Integer, Pair<ChangeItem, Set<ChangeItem>>>();
        this.buildArtIdToChangeMap(changes, artToChanges);
        this.buildLists(artToChanges, newArts, modArts, deletedArts);
        final TypeCountWriter writer = new TypeCountWriter(this.orcsApi);
        String fileName = String.format("Type_Count_Report_%s", System.currentTimeMillis());
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream outputStream) throws WebApplicationException, IOException {
                writer.write(branch, newArts, modArts, deletedArts, artTypes, attrTypes, outputStream);
                outputStream.flush();
            }
        };
        String contentDisposition = String.format("attachment; filename=\"%s.xml\"; creation-date=\"%s\"", fileName, new Date());
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)contentDisposition).type("application/xml").build();
    }

    private void buildArtIdToChangeMap(List<ChangeItem> changes, Map<Integer, Pair<ChangeItem, Set<ChangeItem>>> artToChanges) {
        for (ChangeItem change : changes) {
            Pair<ChangeItem, Set<ChangeItem>> pair;
            int artId = change.getArtId().getId().intValue();
            ChangeType changeType = change.getChangeType();
            if (changeType.isArtifactChange()) {
                if (!artToChanges.containsKey(artId)) {
                    artToChanges.put(artId, (Pair<ChangeItem, Set<ChangeItem>>)new Pair((Object)change, new HashSet()));
                    continue;
                }
                pair = artToChanges.get(artId);
                pair.setFirst((Object)change);
                continue;
            }
            if (!changeType.isAttributeChange()) continue;
            if (!artToChanges.containsKey(artId)) {
                HashSet<ChangeItem> changeSet = new HashSet<ChangeItem>();
                changeSet.add(change);
                artToChanges.put(artId, (Pair<ChangeItem, Set<ChangeItem>>)new Pair(null, changeSet));
                continue;
            }
            pair = artToChanges.get(artId);
            Set changeSet = (Set)pair.getSecond();
            changeSet.add(change);
        }
    }

    private void buildLists(Map<Integer, Pair<ChangeItem, Set<ChangeItem>>> artToChanges, Set<Long> newArts, Set<Long> modArts, Set<Long> deletedArts) {
        AttributeTypes attributeTypes = this.orcsApi.getOrcsTypes().getAttributeTypes();
        ArtifactTypes artifactTypes = this.orcsApi.getOrcsTypes().getArtifactTypes();
        for (Integer artId : artToChanges.keySet()) {
            Pair<ChangeItem, Set<ChangeItem>> pair = artToChanges.get(artId);
            ChangeItem artChange = (ChangeItem)pair.getFirst();
            ModificationType modType = artChange.getNetChange().getModType();
            if (modType.equals(ModificationType.NEW)) {
                newArts.add((long)artId);
                continue;
            }
            if (modType.equals(ModificationType.DELETED)) {
                deletedArts.add((long)artId);
                continue;
            }
            if (!modType.equals(ModificationType.MODIFIED) || !this.isCountable(artChange, (Set)pair.getSecond(), attributeTypes, artifactTypes)) continue;
            modArts.add((long)artId);
        }
    }

    private boolean isCountable(ChangeItem artChange, Set<ChangeItem> attrChanges, AttributeTypes attributeTypes, ArtifactTypes artTypes) {
        boolean toReturn = false;
        for (ChangeItem change : attrChanges) {
            AttributeTypeId attrType = (AttributeTypeId)attributeTypes.get(change.getItemTypeId());
            if (!attrType.matches(new Id[]{CoreAttributeTypes.WordTemplateContent})) continue;
            toReturn = true;
            break;
        }
        return toReturn;
    }

    private List<ChangeItem> getChanges(BranchId branch) {
        List results = this.atsApi.getBranchService().getChangeData(branch);
        if (results != null) {
            return results;
        }
        return Collections.emptyList();
    }
}

