/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.cache;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.enums.OseeCacheEnum;
import org.eclipse.osee.framework.core.model.cache.AbstractOseeCache;
import org.eclipse.osee.framework.core.model.cache.IOseeDataAccessor;
import org.eclipse.osee.framework.core.model.cache.IOseeLoadingCache;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public abstract class AbstractOseeLoadingCache<T extends NamedIdBase>
extends AbstractOseeCache<T>
implements IOseeLoadingCache<T> {
    private final IOseeDataAccessor<T> dataAccessor;
    private final AtomicBoolean wasLoaded = new AtomicBoolean(false);
    private long lastLoaded = 0L;

    protected AbstractOseeLoadingCache(OseeCacheEnum cacheId, IOseeDataAccessor<T> dataAccessor) {
        super(cacheId);
        this.dataAccessor = dataAccessor;
    }

    @Override
    public long getLastLoaded() {
        return this.lastLoaded;
    }

    private void setLastLoaded(long lastLoaded) {
        this.lastLoaded = lastLoaded;
    }

    @Override
    public boolean isLoaded() {
        return this.wasLoaded.get();
    }

    @Override
    public void invalidate() {
        this.wasLoaded.set(false);
    }

    @Override
    public synchronized void decacheAll() {
        super.decacheAll();
        this.invalidate();
    }

    @Override
    public synchronized void ensurePopulated() {
        if (this.wasLoaded.compareAndSet(false, true)) {
            try {
                this.reloadCache();
            }
            catch (OseeCoreException ex) {
                this.wasLoaded.set(false);
                throw ex;
            }
        }
    }

    @Override
    public synchronized boolean reloadCache() {
        this.dataAccessor.load(this);
        OseeLog.log(this.getClass(), (Level)Level.INFO, (String)("Loaded " + this.getCacheId().toString().toLowerCase()));
        this.setLastLoaded(System.currentTimeMillis());
        this.wasLoaded.set(true);
        return true;
    }
}

