/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.template.engine.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.osee.framework.jdk.core.type.ResourceToken;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.jaxrs.mvc.AbstractViewResolver;
import org.eclipse.osee.template.engine.AppendableRule;
import org.eclipse.osee.template.engine.PageCreator;
import org.eclipse.osee.template.engine.PageFactory;
import org.eclipse.osee.template.engine.internal.TemplateRegistry;

public class PageFactoryViewResolver
extends AbstractViewResolver<ResourceToken> {
    private TemplateRegistry registry;

    public void setTemplateRegistry(TemplateRegistry registry) {
        this.registry = registry;
    }

    public ResourceToken resolve(String viewId, MediaType mediaType) {
        ResourceToken toReturn = null;
        if (MediaType.TEXT_HTML_TYPE.equals((Object)mediaType) || MediaType.WILDCARD_TYPE.equals((Object)mediaType)) {
            toReturn = this.registry.resolveTemplate(viewId, mediaType);
        }
        return toReturn;
    }

    public void write(ViewModel model, ResourceToken view, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream output, Charset encoding) throws IOException {
        PageCreator pageCreator = PageFactory.newPageCreator(this.registry.getResourceRegistry(), new String[0]);
        for (Map.Entry entry : model.asMap().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AppendableRule) {
                pageCreator.addSubstitution((AppendableRule)value);
                continue;
            }
            pageCreator.addKeyValuePair(key, String.valueOf(value));
        }
        OutputStreamWriter writer = new OutputStreamWriter(output, encoding);
        try {
            pageCreator.realizePage(view, writer);
        }
        finally {
            writer.flush();
        }
    }
}

