/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.template.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.template.engine.AppendableRule;

public class ArtifactTypeOptionsRule
extends AppendableRule<String> {
    public static final String RULE_NAME = "artifactTypeSelect";
    private final Set<String> typeNames;
    private final Set<String> preselectedTypeNames;
    private String selectId;
    private static final String theJavaScript = "<script type=\"text/javascript\">\nfunction typeSelected() {\n    var available = document.getElementById(\"%s\");\n    var selected = document.getElementById(\"%s\");\n    var availableOptions = available.options;\n    if(available.selectedIndex > -1) {\n        var index = available.selectedIndex\n        var text =  availableOptions[index].text;\n        if (!text) {\n            return;\n        }\n        var foundIt = false;\n        var counter = 0;\n        var selectedOptions = selected.options;\n        while ((counter < selectedOptions.length) && !foundIt) {\n            if (selectedOptions[counter].text == text) {\n                foundIt = true;\n            }\n        counter++;\n        }\n        if (!foundIt) {\n            var option = document.createElement(\"option\");\n            option.text = text;\n            option.value = availableOptions[index].value;\n            selected.add(option);\n        }\n    }\n    available.selectedIndex = -1;\n}\nfunction typeDeselected(evnt) {\n    var selected = document.getElementById(\"%s\");\n    var options = selected.options;\n    while(selected.selectedIndex > -1) {\n        selected.remove(selected.selectedIndex)\n    }\n    if (evnt) {\n       evnt.preventDefault();\n       evnt.returnValue = false;\n    }\n}\n</script>";

    public ArtifactTypeOptionsRule(String selectId, Set<String> typeNames, Set<String> preselectedTypeNames) {
        super(RULE_NAME);
        Conditions.checkNotNull((Object)selectId, (String)"selection id");
        Conditions.checkNotNull(typeNames, (String)"types");
        Conditions.checkNotNull(preselectedTypeNames, (String)"preseleted types");
        this.typeNames = typeNames;
        this.preselectedTypeNames = preselectedTypeNames;
        this.selectId = selectId;
    }

    @Override
    public void applyTo(Appendable appendable, Map<String, String> attributes) throws IOException {
        String value = attributes.get("id");
        if (value == null) {
            throw new IOException("no base type specified for artifact select rule");
        }
        this.selectId = value;
        value = attributes.get("types");
        if (value == null) {
            throw new IOException("no base type specified for artifact select rule");
        }
        this.parseStringToSet(value, this.typeNames);
        value = attributes.get("preselect");
        if (value != null) {
            this.parseStringToSet(value, this.preselectedTypeNames);
        }
        this.applyTo(appendable);
    }

    private void parseStringToSet(String toParse, Set<String> types) {
        StringTokenizer splitter = new StringTokenizer(toParse, ",");
        while (splitter.hasMoreTokens()) {
            types.add(splitter.nextToken().trim());
        }
    }

    @Override
    public void applyTo(Appendable appendable) throws IOException {
        ArrayList<String> sortedList = new ArrayList<String>();
        for (String type : this.typeNames) {
            sortedList.add(type);
        }
        Collections.sort(sortedList);
        String availableName = String.valueOf(this.selectId) + "_available";
        appendable.append("<select id=\"");
        appendable.append(availableName);
        appendable.append("\" onchange=\"typeSelected()\">\n");
        appendable.append("<option value=\"\" selected></option>/n");
        for (String name : sortedList) {
            appendable.append("<option value=\"");
            appendable.append(name);
            appendable.append("\">");
            appendable.append(name);
            appendable.append("</option>\n");
        }
        appendable.append("</select><br>\n");
        appendable.append("<select id=\"");
        appendable.append(this.selectId);
        appendable.append("\" multiple oncontextmenu=\"typeDeselected(event)\">\n");
        if (this.preselectedTypeNames != null) {
            for (String name : this.preselectedTypeNames) {
                appendable.append("<option value=\"");
                appendable.append(name);
                appendable.append("\">");
                appendable.append(name);
                appendable.append("</option>\n");
            }
        }
        appendable.append("</select><br>\n");
        appendable.append(String.format(theJavaScript, availableName, this.selectId, this.selectId));
    }
}

