/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InputBufferThread
extends Thread {
    private final byte[] charBuffer = new byte[1024];
    private final InputStream input;
    private final StringBuilder buffer;
    private volatile boolean shouldStopRunning = false;
    private long lastRead;

    public InputBufferThread(InputStream input) {
        super("Stream input buffer thread");
        this.input = input;
        this.buffer = new StringBuilder(8196);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block66: {
            System.out.println("thread started");
            int count = 0;
            try {
                int size = this.input.read(this.charBuffer);
                while (size >= 0) {
                    ++count;
                    InputBufferThread inputBufferThread = this;
                    synchronized (inputBufferThread) {
                        this.lastRead = System.currentTimeMillis();
                        if (this.shouldStopRunning) {
                            break;
                        }
                        this.append(this.charBuffer, size);
                    }
                    size = this.input.read(this.charBuffer);
                }
            }
            catch (InterruptedIOException e) {
                if (!this.shouldStopRunning) {
                    e.printStackTrace(System.err);
                }
                try {
                    try {
                        this.input.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace(System.out);
                        System.out.flush();
                        InputBufferThread inputBufferThread = this;
                        synchronized (inputBufferThread) {
                            this.notifyAll();
                            break block66;
                        }
                    }
                }
                catch (Throwable throwable) {
                    InputBufferThread inputBufferThread = this;
                    synchronized (inputBufferThread) {
                        this.notifyAll();
                    }
                    throw throwable;
                }
                InputBufferThread inputBufferThread = this;
                synchronized (inputBufferThread) {
                    this.notifyAll();
                    break block66;
                }
            }
            catch (IOException e) {
                block67: {
                    try {
                        if (this.shouldStopRunning) break block67;
                        System.err.println("error at count " + count);
                        e.printStackTrace(System.err);
                    }
                    catch (Throwable throwable) {
                        block70: {
                            try {
                                try {
                                    this.input.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace(System.out);
                                    System.out.flush();
                                    InputBufferThread inputBufferThread = this;
                                    synchronized (inputBufferThread) {
                                        this.notifyAll();
                                        break block70;
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                InputBufferThread inputBufferThread = this;
                                synchronized (inputBufferThread) {
                                    this.notifyAll();
                                }
                                throw throwable2;
                            }
                            InputBufferThread inputBufferThread = this;
                            synchronized (inputBufferThread) {
                                this.notifyAll();
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    try {
                        this.input.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace(System.out);
                        System.out.flush();
                        InputBufferThread inputBufferThread = this;
                        synchronized (inputBufferThread) {
                            this.notifyAll();
                            break block66;
                        }
                    }
                }
                catch (Throwable throwable) {
                    InputBufferThread inputBufferThread = this;
                    synchronized (inputBufferThread) {
                        this.notifyAll();
                    }
                    throw throwable;
                }
                InputBufferThread inputBufferThread = this;
                synchronized (inputBufferThread) {
                    this.notifyAll();
                    break block66;
                }
            }
            try {
                try {
                    this.input.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                    System.out.flush();
                    InputBufferThread inputBufferThread = this;
                    synchronized (inputBufferThread) {
                        this.notifyAll();
                        break block66;
                    }
                }
            }
            catch (Throwable throwable) {
                InputBufferThread inputBufferThread = this;
                synchronized (inputBufferThread) {
                    this.notifyAll();
                }
                throw throwable;
            }
            InputBufferThread inputBufferThread = this;
            synchronized (inputBufferThread) {
                this.notifyAll();
            }
        }
    }

    private void append(byte[] line, int size) {
        this.buffer.append(new String(line, 0, size));
        this.notify();
    }

    public synchronized int contains(String matcher, boolean remove) {
        int index = this.buffer.lastIndexOf(matcher);
        if (remove && index >= 0) {
            this.buffer.delete(0, index + matcher.length());
        }
        return index;
    }

    public synchronized int contains(String matcher) {
        return this.contains(matcher, false);
    }

    public synchronized int waitFor(String matcher, int millis) throws InterruptedException {
        return this.waitFor(matcher, false, millis);
    }

    public synchronized int waitFor(String matcher, boolean remove, int millis) throws InterruptedException {
        if (this.shouldStopRunning) {
            throw new IllegalStateException("stream processing terminated");
        }
        long time = System.currentTimeMillis();
        int result = this.contains(matcher, false);
        long timeRemaining = millis;
        while (result < 0 && timeRemaining > 0L) {
            this.wait(timeRemaining);
            if (this.shouldStopRunning) {
                throw new InterruptedException("stream processing terminated");
            }
            result = this.contains(matcher, false);
            timeRemaining = (long)millis - (System.currentTimeMillis() - time);
        }
        if (remove && result >= 0) {
            this.buffer.delete(0, result + matcher.length());
        }
        return result;
    }

    public synchronized MatchResult waitFor(Pattern pattern, boolean remove, int millis) throws InterruptedException {
        if (this.shouldStopRunning) {
            throw new IllegalStateException("stream processing terminated");
        }
        Matcher matcher = pattern.matcher(this.buffer.toString());
        long time = System.currentTimeMillis();
        long timeRemaining = millis;
        boolean result = matcher.matches();
        while (!result && timeRemaining > 0L) {
            this.wait(timeRemaining);
            if (this.shouldStopRunning) {
                throw new InterruptedException("stream processing terminated");
            }
            matcher = matcher.reset(this.buffer.toString());
            result = matcher.matches();
            timeRemaining = (long)millis - (System.currentTimeMillis() - time);
        }
        if (remove && result) {
            this.buffer.delete(0, matcher.end());
        }
        return result ? matcher.toMatchResult() : null;
    }

    public synchronized boolean waitFor(int millis) throws InterruptedException {
        if (this.shouldStopRunning) {
            throw new IllegalStateException("stream processing terminated");
        }
        long currentTime = System.currentTimeMillis();
        long savedLastRead = this.lastRead;
        while (savedLastRead != this.lastRead) {
            this.wait(millis);
            long next = System.currentTimeMillis();
            millis = (int)((long)millis - (next - currentTime));
            currentTime = next;
            if (savedLastRead != this.lastRead || millis > 0) continue;
            return false;
        }
        return true;
    }

    public synchronized String getBuffer() {
        return this.buffer.toString();
    }

    public synchronized String subString(int beginIndex) {
        return this.buffer.substring(beginIndex);
    }

    public synchronized String subString(int beginIndex, int endIndex) {
        return this.buffer.substring(beginIndex, endIndex);
    }

    public synchronized int getLength() {
        return this.buffer.length();
    }

    public void stopOnNextRun(boolean b) {
        this.shouldStopRunning = b;
    }

    public void stopNow() throws InterruptedException {
        this.shouldStopRunning = true;
        this.interrupt();
        this.join(5000L);
    }

    public synchronized long getLastRead() {
        if (this.lastRead == 0L) {
            return System.currentTimeMillis();
        }
        return this.lastRead;
    }

    public synchronized void clear() {
        this.buffer.delete(0, this.buffer.length());
    }
}

