/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;

public class ElapsedTimeMulti {
    Map<String, Long> idToTime = new HashMap<String, Long>();
    Map<String, Date> idToStartDate = new HashMap<String, Date>();
    private String name;

    public ElapsedTimeMulti(String name) {
        this.restart(name);
    }

    public void restart(String name) {
        this.idToTime.clear();
        this.idToStartDate.clear();
        this.name = name;
        this.start(name);
    }

    public void start(String name) {
        this.idToStartDate.put(name, new Date());
    }

    public void stop(String name) {
        Long stored = this.idToTime.get(name);
        Long elapsed = new Date().getTime() - this.idToStartDate.get(name).getTime();
        stored = stored == null ? elapsed : Long.valueOf(stored + elapsed);
        this.idToTime.put(name, stored);
    }

    public void report(ElapsedTime.Units units) {
        Date now = new Date();
        System.err.println("\n=========== Start ============");
        this.printName(now, this.name, units);
        for (Map.Entry<String, Long> entry : this.idToTime.entrySet()) {
            if (entry.getKey().equals(this.name)) continue;
            this.printName(now, entry.getKey(), units);
        }
        System.err.println("=========== End ============\n");
    }

    private void printName(Date endDate, String name, ElapsedTime.Units units) {
        long timeSpent;
        Date startDate = this.idToStartDate.get(name);
        long time = timeSpent = endDate.getTime() - startDate.getTime();
        String milliseconds = "";
        if (units == ElapsedTime.Units.SEC) {
            time /= 1000L;
            milliseconds = "";
        } else if (units == ElapsedTime.Units.MIN) {
            time /= 60000L;
            milliseconds = " ( " + timeSpent + " ms ) ";
        }
        String str = String.format("%s- elapsed %d %s%s - start %s - end %s\n", name, time, units.name(), milliseconds, DateUtil.getDateStr(startDate, "hh:mm:ss:SS"), DateUtil.getDateStr(endDate, "hh:mm:ss:SS"));
        System.err.println(str);
    }
}

