/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.Date;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;

public class ElapsedTime {
    Date startDate;
    Date endDate;
    private String name;
    private final boolean logStart;

    public ElapsedTime(String name) {
        this(name, false);
    }

    public ElapsedTime(String name, boolean logStart) {
        this.logStart = logStart;
        this.start(name);
    }

    public void start(String name) {
        this.name = name;
        this.startDate = new Date();
        if (this.logStart) {
            System.err.println("\n" + name + " - start " + DateUtil.getTimeStamp());
        }
    }

    public void logPoint(String pointName) {
        System.err.println("\n" + this.name + " - [" + pointName + "] " + DateUtil.getTimeStamp());
    }

    public String end() {
        return this.end(Units.SEC);
    }

    public String end(Units units) {
        return this.end(units, true);
    }

    public String end(Units units, boolean printToSysErr) {
        long timeSpent;
        this.endDate = new Date();
        long time = timeSpent = this.endDate.getTime() - this.startDate.getTime();
        String milliseconds = "";
        if (units == Units.SEC) {
            time /= 1000L;
            milliseconds = "";
        } else if (units == Units.MIN) {
            time /= 60000L;
            milliseconds = " ( " + timeSpent + " ms ) ";
        }
        String str = String.format("%s- elapsed %d %s%s - start %s - end %s", this.name, time, units.name(), milliseconds, DateUtil.getDateStr(this.startDate, "hh:mm:ss:SS"), DateUtil.getDateStr(this.endDate, "hh:mm:ss:SS"));
        if (printToSysErr) {
            System.err.println(String.valueOf(str) + (this.logStart ? "" : "\n"));
        }
        return str;
    }

    public Long getTimeSpent() {
        Date endDate = new Date();
        return endDate.getTime() - this.startDate.getTime();
    }

    public static enum Units {
        SEC,
        MSEC,
        MIN;

    }
}

