/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.function.Function;
import org.eclipse.osee.framework.jdk.core.type.BaseId;

public interface Id {
    public static final Long SENTINEL = -1L;

    public static <R> R valueOf(String id, Function<Long, R> function) {
        if (id == null || id.equals("") || id.equals("null")) {
            return function.apply(SENTINEL);
        }
        return function.apply(Long.valueOf(id));
    }

    public static Id valueOf(String id) {
        return Id.valueOf(id, BaseId::new);
    }

    public static Id valueOf(int id) {
        return new BaseId(Long.valueOf(id));
    }

    public static Id valueOf(Long id) {
        return new BaseId(id);
    }

    public Long getId();

    default public int getIdIntValue() {
        return this.getId().intValue();
    }

    default public String getIdString() {
        return String.valueOf(this.getId());
    }

    default public boolean matches(Id ... ids) {
        Id[] idArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Id id = idArray[n2];
            if (this.equals(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    default public boolean matches(Iterable<? extends Id> ids) {
        for (Id id : ids) {
            if (!this.equals(id)) continue;
            return true;
        }
        return false;
    }

    default public boolean equals(Long id) {
        return this.getId().equals(id);
    }

    default public boolean notEqual(Long id) {
        return !this.equals(id);
    }

    default public boolean notEqual(Id id) {
        return !this.equals(id);
    }

    @JsonIgnore
    default public boolean isValid() {
        Long id = this.getId();
        return id != null && id > 0L;
    }

    @JsonIgnore
    default public boolean isInvalid() {
        return !this.isValid();
    }

    default public <T extends Id> T minus(T id) {
        return this.clone(this.getId() - id.getId());
    }

    default public <T extends Id> T plus(T id) {
        return this.clone(this.getId() + id.getId());
    }

    default public <T extends Id> T increment(long increment) {
        return this.clone(this.getId() + increment);
    }

    default public <T extends Id> T increment() {
        return this.clone(this.getId() + 1L);
    }

    default public <T extends Id> T clone(Long id) {
        throw new UnsupportedOperationException();
    }

    default public boolean isLessThan(Id other) {
        return this.getId() < other.getId();
    }

    default public boolean isGreaterThan(Id other) {
        return this.getId() > other.getId();
    }
}

