/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authorization.admin;

import java.util.Date;
import org.eclipse.osee.authorization.admin.AuthorizationRequest;

public final class AuthorizationRequestBuilder {
    private boolean isSecure;
    private Date date;
    private String path;
    private String method;
    private String authType;
    private long identifier;

    private AuthorizationRequestBuilder() {
    }

    public static AuthorizationRequestBuilder newBuilder() {
        return new AuthorizationRequestBuilder();
    }

    public AuthorizationRequest build() {
        return new AuthorizationRequestImpl(this.isSecure, this.date, this.path, this.method, this.authType, this.identifier);
    }

    public AuthorizationRequestBuilder secure(boolean isSecure) {
        this.isSecure = isSecure;
        return this;
    }

    public AuthorizationRequestBuilder date(Date date) {
        this.date = date;
        return this;
    }

    public AuthorizationRequestBuilder identifier(long identifier) {
        this.identifier = identifier;
        return this;
    }

    public AuthorizationRequestBuilder method(String method) {
        this.method = method;
        return this;
    }

    public AuthorizationRequestBuilder path(String path) {
        this.path = path;
        return this;
    }

    public AuthorizationRequestBuilder authorizationType(String authType) {
        this.authType = authType;
        return this;
    }

    private static final class AuthorizationRequestImpl
    implements AuthorizationRequest {
        private final boolean isSecure;
        private final Date requestDate;
        private final String path;
        private final String method;
        private final String authType;
        private final long identifier;

        public AuthorizationRequestImpl(boolean isSecure, Date requestDate, String path, String method, String authType, long identifier) {
            this.isSecure = isSecure;
            this.requestDate = requestDate;
            this.path = path;
            this.method = method;
            this.authType = authType;
            this.identifier = identifier;
        }

        @Override
        public boolean isSecure() {
            return this.isSecure;
        }

        @Override
        public Date getRequestDate() {
            return this.requestDate;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public String getAuthorizationType() {
            return this.authType;
        }

        @Override
        public long getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "AuthorizationRequestImpl [isSecure=" + this.isSecure + ", requestDate=" + this.requestDate + ", path=" + this.path + ", method=" + this.method + ", authType=" + this.authType + ", identifier" + this.identifier + "]";
        }
    }
}

