/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client.internal.ext;

import java.net.URI;
import javax.crypto.SecretKey;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.client.JaxRsConfirmAccessHandler;
import org.eclipse.osee.jaxrs.client.JaxRsTokenStore;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Flows;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Serializer;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Util;

@Provider
public class OAuth2ClientRequestFilter
implements ClientRequestFilter {
    private final OAuth2Flows flows;
    private final OAuth2Serializer serializer;
    private String redirectUri;
    private String scopes;
    private String secretKeyEncoded;
    private String secretKeyAlgorithm;
    private JaxRsTokenStore tokenStore;
    private JaxRsConfirmAccessHandler handler;
    private ClientAccessTokenCache cache;
    private volatile SecretKey secretKey;
    private boolean failOnRefreshTokenError;

    public OAuth2ClientRequestFilter(OAuth2Flows flows, OAuth2Serializer serializer) {
        this.flows = flows;
        this.serializer = serializer;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = "urn:ietf:wg:oauth:2.0:oob".equals(redirectUri) ? null : redirectUri;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public void setTokenStore(JaxRsTokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setTokenHandler(JaxRsConfirmAccessHandler handler) {
        this.handler = handler;
    }

    public void setSecretKeyEncoded(String secretKeyEncoded) {
        this.secretKeyEncoded = secretKeyEncoded;
    }

    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    public void setFailOnRefreshTokenError(boolean failOnRefreshTokenError) {
        this.failOnRefreshTokenError = failOnRefreshTokenError;
    }

    private boolean isTokenEncryptionEnabled() {
        return Strings.isValid((String)this.secretKeyEncoded);
    }

    private boolean isFailOnRefreshTokenError() {
        return this.failOnRefreshTokenError;
    }

    public void setClientAccessTokenCache(ClientAccessTokenCache cache) {
        this.cache = cache;
    }

    private SecretKey getSecretKey() {
        if (this.secretKey == null) {
            this.secretKey = this.serializer.decodeSecretKey(this.secretKeyEncoded, this.secretKeyAlgorithm);
        }
        return this.secretKey;
    }

    public void filter(ClientRequestContext context) {
        String authHeader;
        URI requestedUri = context.getUri();
        ClientAccessToken accessToken = this.getAccessToken(requestedUri);
        String tokenType = accessToken.getTokenType();
        if ("bearer".equals(tokenType)) {
            authHeader = OAuth2Util.asAuthorizationHeader(accessToken);
        } else if ("hawk".equals(tokenType)) {
            String httpMethod = context.getMethod();
            authHeader = OAuth2Util.asAuthorizationHeader(accessToken, httpMethod, requestedUri);
        } else {
            throw OAuth2Util.newException("Unsupported token type exception [%s]", tokenType);
        }
        context.getHeaders().addFirst((Object)"Authorization", (Object)authHeader);
    }

    private ClientAccessToken getAccessToken(URI requestedUri) {
        ClientAccessToken token = null;
        if (this.cache != null) {
            token = this.cache.get(requestedUri);
        }
        if (token == null) {
            token = this.getFromStorage(requestedUri);
        }
        if (!this.isValidToken(token) && this.isValidToken(token = this.getNewToken(token))) {
            if (this.cache != null) {
                this.cache.store(requestedUri, token);
            }
            this.store(requestedUri, token);
        }
        return token;
    }

    private ClientAccessToken getFromStorage(URI requestedUri) {
        String storedToken;
        ClientAccessToken token = null;
        if (this.tokenStore != null && Strings.isValid((String)(storedToken = this.tokenStore.getToken(requestedUri)))) {
            token = this.isTokenEncryptionEnabled() ? this.serializer.decryptAccessToken(storedToken, this.getSecretKey()) : this.serializer.fromJson(storedToken);
        }
        return token;
    }

    private void store(URI requestedUri, ClientAccessToken token) {
        if (this.tokenStore != null) {
            String tokenString = this.isTokenEncryptionEnabled() ? this.serializer.encryptAccessToken(token, this.getSecretKey()) : this.serializer.toJson(token);
            this.tokenStore.storeToken(requestedUri, tokenString);
        }
    }

    private ClientAccessToken getNewToken(ClientAccessToken oldToken) {
        ClientAccessToken newToken;
        block4: {
            newToken = null;
            if (oldToken != null && this.isExpired(oldToken) && Strings.isValid((String)oldToken.getRefreshToken())) {
                try {
                    newToken = this.flows.refreshFlow(oldToken, this.flows.generateState());
                }
                catch (Exception ex) {
                    if (!this.isFailOnRefreshTokenError()) break block4;
                    throw OAuth2Util.newException(ex, "Error while attempting to refresh access token", new Object[0]);
                }
            }
        }
        if (!this.isValidToken(newToken)) {
            newToken = this.flows.authorizationCodeFlow(this.handler, this.flows.generateState(), this.scopes, this.redirectUri);
        }
        return newToken;
    }

    private boolean isValidToken(ClientAccessToken token) {
        return token != null && !this.isExpired(token);
    }

    private boolean isExpired(ClientAccessToken storedToken) {
        return OAuthUtils.isExpired((Long)storedToken.getIssuedAt(), (Long)storedToken.getExpiresIn());
    }

    public static interface ClientAccessTokenCache {
        public ClientAccessToken get(URI var1);

        public void store(URI var1, ClientAccessToken var2);
    }
}

