/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client.internal.ext;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spec.ClientImpl;
import org.eclipse.osee.jaxrs.client.JaxRsWebTarget;

public class JaxRsWebTargetImpl
implements JaxRsWebTarget {
    private final WebTarget target;

    public JaxRsWebTargetImpl(WebTarget target) {
        this.target = target;
    }

    public Configuration getConfiguration() {
        return this.target.getConfiguration();
    }

    public JaxRsWebTarget property(String name, Object value) {
        this.target.property(name, value);
        return this;
    }

    public JaxRsWebTarget register(Class<?> componentClass) {
        this.target.register(componentClass);
        return this;
    }

    public JaxRsWebTarget register(Class<?> componentClass, int priority) {
        this.target.register(componentClass, priority);
        return this;
    }

    public JaxRsWebTarget register(Class<?> componentClass, Class<?> ... contracts) {
        this.target.register(componentClass, (Class[])contracts);
        return this;
    }

    public JaxRsWebTarget register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.target.register(componentClass, contracts);
        return this;
    }

    public JaxRsWebTarget register(Object component) {
        this.target.register(component);
        return this;
    }

    public JaxRsWebTarget register(Object component, int priority) {
        this.target.register(component, priority);
        return this;
    }

    public JaxRsWebTarget register(Object component, Class<?> ... contracts) {
        this.target.register(component, (Class[])contracts);
        return this;
    }

    public JaxRsWebTarget register(Object component, Map<Class<?>, Integer> contracts) {
        this.target.register(component, contracts);
        return this;
    }

    @Override
    public URI getUri() {
        return this.target.getUri();
    }

    @Override
    public UriBuilder getUriBuilder() {
        return this.target.getUriBuilder();
    }

    @Override
    public Invocation.Builder request() {
        return this.target.request();
    }

    @Override
    public Invocation.Builder request(String ... acceptedResponseTypes) {
        return this.target.request(acceptedResponseTypes);
    }

    @Override
    public Invocation.Builder request(MediaType ... acceptedResponseTypes) {
        return this.target.request(acceptedResponseTypes);
    }

    protected WebClient getWebClient() {
        WebClient webClient = null;
        if (this.target instanceof ClientImpl.WebTargetImpl) {
            webClient = ((ClientImpl.WebTargetImpl)this.target).getWebClient();
        }
        return webClient;
    }

    @Override
    public <T> T newProxy(Class<T> clazz) {
        this.target.request();
        WebClient webClient = this.getWebClient();
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clazz);
    }
}

