/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.client.JaxRsClient;
import org.eclipse.osee.jaxrs.client.internal.ext.CxfJaxRsClientConfigurator;
import org.eclipse.osee.jaxrs.client.internal.ext.CxfJaxRsClientFactory;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2ClientRequestFilter;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Flows;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Serializer;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Transport;

public final class JaxRsClientRuntime {
    public static final long MAX_TOKEN_CACHE_EVICT_TIMEOUT_MILLIS = 86400000L;
    private static volatile JaxRsClient.JaxRsClientFactory instance;

    private JaxRsClientRuntime() {
    }

    public static JaxRsClient.JaxRsClientFactory getClientFactoryInstance() {
        if (instance == null) {
            instance = JaxRsClientRuntime.newClientFactory();
        }
        return instance;
    }

    private static JaxRsClient.JaxRsClientFactory newClientFactory() {
        CxfJaxRsClientConfigurator.OAuthFactory oauthFactory = JaxRsClientRuntime.newOAuthFactory();
        CxfJaxRsClientConfigurator configurator = new CxfJaxRsClientConfigurator(oauthFactory);
        configurator.configureJaxRsRuntime();
        configurator.configureDefaults(Collections.emptyMap());
        return new CxfJaxRsClientFactory(configurator);
    }

    private static CxfJaxRsClientConfigurator.OAuthFactory newOAuthFactory() {
        return new CxfJaxRsClientConfigurator.OAuthFactory(){

            @Override
            public OAuth2ClientRequestFilter newOAuthClientFilter(String username, String password, String clientId, String clientSecret, String authorizeUri, String tokenUri, String tokenValidationUri) {
                OAuth2Flows.OwnerCredentials owner = JaxRsClientRuntime.newOwner(username, password);
                OAuthClientUtils.Consumer client = new OAuthClientUtils.Consumer(clientId, clientSecret);
                OAuth2Transport transport = new OAuth2Transport();
                OAuth2Flows flowManager = new OAuth2Flows(transport, owner, client, authorizeUri, tokenUri, tokenValidationUri);
                OAuth2Serializer serializer = new OAuth2Serializer();
                return new OAuth2ClientRequestFilter(flowManager, serializer);
            }

            @Override
            public OAuth2ClientRequestFilter.ClientAccessTokenCache newClientAccessTokenCache(int cacheMaxSize, long cacheEvictTimeoutMillis) {
                final Cache cache = JaxRsClientRuntime.newCache(cacheMaxSize, cacheEvictTimeoutMillis);
                return new OAuth2ClientRequestFilter.ClientAccessTokenCache(){

                    @Override
                    public ClientAccessToken get(URI key) {
                        return (ClientAccessToken)cache.getIfPresent((Object)key);
                    }

                    @Override
                    public void store(URI key, ClientAccessToken value) {
                        cache.put((Object)key, (Object)value);
                    }
                };
            }
        };
    }

    private static <K, V> Cache<K, V> newCache(int cacheMaxSize, long cacheEvictTimeoutMillis) {
        Conditions.checkExpressionFailOnTrue((cacheMaxSize <= 0 ? 1 : 0) != 0, (String)"Token Cache max size must be greater than 0", (Object[])new Object[0]);
        Conditions.checkExpressionFailOnTrue((cacheEvictTimeoutMillis > 86400000L ? 1 : 0) != 0, (String)"Token cache evict timeout exceeds max - [%s]", (Object[])new Object[]{Lib.asTimeString((long)86400000L)});
        Conditions.checkExpressionFailOnTrue((cacheEvictTimeoutMillis <= 0L ? 1 : 0) != 0, (String)"Token cache evict timeout must be greater than 0", (Object[])new Object[0]);
        return CacheBuilder.newBuilder().maximumSize((long)cacheMaxSize).expireAfterWrite(cacheEvictTimeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    private static OAuth2Flows.OwnerCredentials newOwner(final String username, final String password) {
        return new OAuth2Flows.OwnerCredentials(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public String getPassword() {
                return password;
            }
        };
    }
}

