/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.annotations.OseeAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.CharacterBackedAttribute;

@OseeAttribute(value="IntegerAttribute")
public class IntegerAttribute
extends CharacterBackedAttribute<Integer> {
    public static final String NAME = IntegerAttribute.class.getSimpleName();
    private static final Integer DEFAULT_INTEGER = Integer.MIN_VALUE;

    public IntegerAttribute(Long id) {
        super(id);
    }

    @Override
    public Integer convertStringToValue(String value) {
        Integer toReturn = null;
        toReturn = this.isValidInteger(value) ? Integer.valueOf(value) : this.getDefaultValue();
        return toReturn;
    }

    public Integer getDefaultValue() {
        Integer toReturn = DEFAULT_INTEGER;
        String defaultValue = this.getDefaultValueFromMetaData();
        if (this.isValidInteger(defaultValue)) {
            toReturn = Integer.valueOf(defaultValue);
        }
        return toReturn;
    }

    private boolean isValidInteger(String value) {
        boolean result = false;
        if (Strings.isValid((String)value)) {
            try {
                Integer.parseInt(value);
                result = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }
}

