/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.osee.orcs.core.annotations.OseeAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.CharacterBackedAttribute;

@OseeAttribute(value="DateAttribute")
public class DateAttribute
extends CharacterBackedAttribute<Date> {
    public static final String NAME = DateAttribute.class.getSimpleName();
    private static final DateFormat MMDDYYHHMM = new SimpleDateFormat("MM/dd/yyyy hh:mm a");

    public DateAttribute(Long id) {
        super(id);
    }

    @Override
    public String convertToStorageString(Date rawValue) {
        return String.valueOf(rawValue.getTime());
    }

    @Override
    public String getDisplayableString() {
        return this.getAsFormattedString(MMDDYYHHMM);
    }

    @Override
    public Date convertStringToValue(String value) {
        return new Date(Long.parseLong(value));
    }

    public String getAsFormattedString(DateFormat dateFormat) {
        Date date = (Date)this.getValue();
        return date != null ? dateFormat.format(date) : "";
    }
}

