/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.access;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.IUserGroupService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.internal.access.UserGroupImpl;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class UserGroupService
implements IUserGroupService {
    private static UserGroupService userGroupService;
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public static IUserGroup getOseeAdmin() {
        return UserGroupService.get(CoreUserGroups.OseeAdmin);
    }

    public static IUserGroup getOseeAccessAdmin() {
        return UserGroupService.get(CoreUserGroups.OseeAccessAdmin);
    }

    private static IUserGroup get(IUserGroupArtifactToken userGroupArtToken) {
        return UserGroupService.getUserGroupService().getUserGroup(userGroupArtToken);
    }

    private static IUserGroupService getUserGroupService() {
        if (userGroupService == null) {
            userGroupService = new UserGroupService();
        }
        return userGroupService;
    }

    public IUserGroup getUserGroup(IUserGroupArtifactToken userGroup) {
        ArtifactToken art;
        ArtifactReadable userGroupArt = null;
        if (userGroup instanceof ArtifactReadable) {
            userGroupArt = (ArtifactReadable)userGroup;
        }
        if (userGroupArt == null && (art = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)userGroup).getArtifactOrSentinal()).isValid() && art instanceof ArtifactReadable) {
            userGroupArt = (ArtifactReadable)art;
        }
        if (userGroupArt != null) {
            return new UserGroupImpl((ArtifactToken)userGroupArt);
        }
        throw new OseeArgumentException("parameter must be artifact", new Object[0]);
    }

    public Collection<IUserGroupArtifactToken> getMyUserGroups() {
        return UserGroupService.getUserGroupService().getMyUserGroups();
    }

    public boolean isInUserGroup(IUserGroupArtifactToken ... userGroups) {
        Collection myUserGroups = UserGroupService.getUserGroupService().getMyUserGroups();
        IUserGroupArtifactToken[] iUserGroupArtifactTokenArray = userGroups;
        int n = userGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IUserGroupArtifactToken userGrp = iUserGroupArtifactTokenArray[n2];
            if (myUserGroups.contains(userGrp)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isUserMember(IUserGroupArtifactToken userGroup, Long id) {
        ArtifactToken art = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)userGroup).getArtifactOrSentinal();
        if (art.isInvalid()) {
            return false;
        }
        return this.getUserGroup(userGroup).isMember(id);
    }

    public Collection<UserToken> getUsers(IUserGroupArtifactToken userGroup) {
        throw new UnsupportedOperationException();
    }
}

