/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds.criteria;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.data.ArtifactTypes;

public class CriteriaArtifactType
extends Criteria {
    private final Collection<? extends ArtifactTypeId> artifactTypes;
    private final ArtifactTypes artTypeCache;
    private final boolean includeTypeInheritance;

    public CriteriaArtifactType(ArtifactTypes artTypeCache, Collection<? extends ArtifactTypeId> artifactTypes, boolean includeTypeInheritance) {
        this.artifactTypes = artifactTypes;
        this.artTypeCache = artTypeCache;
        this.includeTypeInheritance = includeTypeInheritance;
    }

    @Override
    public void checkValid(Options options) {
        Conditions.checkNotNullOrEmpty(this.artifactTypes, (String)"artifact types");
    }

    public Collection<? extends ArtifactTypeId> getOriginalTypes() {
        return this.artifactTypes;
    }

    public Collection<? extends ArtifactTypeId> getTypes() {
        Collection<? extends ArtifactTypeId> toReturn;
        if (this.includeTypeInheritance) {
            LinkedHashSet<? extends ArtifactTypeId> typesToUse = new LinkedHashSet<ArtifactTypeId>();
            for (ArtifactTypeId artifactTypeId : this.getOriginalTypes()) {
                for (ArtifactTypeId descendant : this.artTypeCache.getAllDescendantTypes(artifactTypeId)) {
                    typesToUse.add((ArtifactTypeId)descendant);
                }
                typesToUse.add((ArtifactTypeId)artifactTypeId);
            }
            toReturn = typesToUse;
        } else {
            toReturn = this.getOriginalTypes();
        }
        return toReturn;
    }

    @Override
    public String toString() {
        return "CriteriaArtifactType [artifactTypes=" + this.artifactTypes + ", includeTypeInheritance=" + this.includeTypeInheritance + "]";
    }
}

